<?php $__env->startSection('title', __('repair::lang.repair')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1><?php echo e(app('translator')->getFromJson('repair::lang.repair')); ?>
        <small></small>
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <?php $__env->startComponent('components.filters', ['title' => __('report.filters'), 'closed' => true]); ?>
        <?php echo $__env->make('sell.partials.sell_list_filters', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <div class="col-md-3">
            <div class="form-group">
                <?php echo Form::label('repair_status_id',  __('repair::lang.repair_status') . ':'); ?>

                <?php echo Form::select('repair_status_id', $repair_status_dropdown, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]);; ?>

            </div>
        </div>
        <?php if(in_array('service_staff' ,$enabled_modules)): ?>
        <div class="col-md-3">
            <div class="form-group">
                <?php echo Form::label('service_staff_id',  __('repair::lang.repaired_by') . ':'); ?>

                <?php echo Form::select('service_staff_id', $service_staffs, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]);; ?>

            </div>
        </div>
        <?php endif; ?>
    <?php echo $__env->renderComponent(); ?>

    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('repair::lang.all_repairs')]); ?>
        <?php $__env->slot('tool'); ?>
            <div class="box-tools">
                <a class="btn btn-block btn-primary" href="<?php echo e(action('\Modules\Repair\Http\Controllers\RepairController@create')); ?>">
                <i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson('messages.add')); ?></a>
            </div>
        <?php $__env->endSlot(); ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="sell_table">
                <thead>
                    <tr>
                        <th><?php echo e(app('translator')->getFromJson('repair::lang.repair_date')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('repair::lang.repair_no')); ?></th>
                        <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                            <th><?php echo e(app('translator')->getFromJson('repair::lang.repaired_by')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(app('translator')->getFromJson('sale.customer_name')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('repair::lang.serial_no')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('repair::lang.repair_status')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('sale.location')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('repair::lang.repair_warranty')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('sale.payment_status')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('sale.total_amount')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('purchase.payment_due')); ?></th>
                        <th><?php echo e(app('translator')->getFromJson('messages.action')); ?></th>
                    </tr>
                </thead>
                <tfoot>
                    <tr class="bg-gray font-17 footer-total text-center">
                        <td <?php if(in_array('service_staff' ,$enabled_modules)): ?> colspan="5" <?php else: ?> colspan="4" <?php endif; ?>><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                        <td id="footer_repair_status_count"></td>
                        <td></td>
                        <td></td>
                        <td id="footer_payment_status_count"></td>
                        <td><span class="display_currency" id="footer_sale_total" data-currency_symbol ="true"></span></td>
                        <td class="text-left"><small><?php echo e(app('translator')->getFromJson('lang_v1.sell_due')); ?> - <span class="display_currency" id="footer_total_remaining" data-currency_symbol ="true"></span><br><?php echo e(app('translator')->getFromJson('lang_v1.sell_return_due')); ?> - <span class="display_currency" id="footer_total_sell_return_due" data-currency_symbol ="true"></span></small></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade payment_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

    <div class="modal fade edit_payment_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel">
    </div>

    <?php echo $__env->make('repair::repair.partials.edit_repair_status_modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>

<script type="text/javascript">
$(document).ready( function(){
    //Date range as a button
    $('#sell_list_filter_date_range').daterangepicker(
        dateRangeSettings,
        function (start, end) {
            $('#sell_list_filter_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            sell_table.ajax.reload();
        }
    );
    $('#sell_list_filter_date_range').on('cancel.daterangepicker', function(ev, picker) {
        $('#sell_list_filter_date_range').val('');
        sell_table.ajax.reload();
    });

    sell_table = $('#sell_table').DataTable({
        processing: true,
        serverSide: true,
        aaSorting: [[0, 'desc']],
        "ajax": {
            "url": "/repair/repair",
            "data": function ( d ) {
                if($('#sell_list_filter_date_range').val()) {
                    var start = $('#sell_list_filter_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                    var end = $('#sell_list_filter_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    d.start_date = start;
                    d.end_date = end;
                }
                d.is_direct_sale = 1;

                d.location_id = $('#sell_list_filter_location_id').val();
                d.customer_id = $('#sell_list_filter_customer_id').val();
                d.payment_status = $('#sell_list_filter_payment_status').val();
                d.sub_type = 'repair';
                d.service_staff_id = $('#service_staff_id').val();
                <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                    d.repair_status_id = $('#repair_status_id').val();
                <?php endif; ?>
            }
        },
        columns: [
            { data: 'transaction_date', name: 'transaction_date'  },
            { data: 'invoice_no', name: 'invoice_no'},
            <?php if(in_array('service_staff' ,$enabled_modules)): ?>
                { data: 'service_staff', name: 'ss.first_name'},
            <?php endif; ?>
            { data: 'name', name: 'contacts.name'},
            { data: 'repair_serial_no', name: 'rs.name'},
            { data: 'repair_status', name: 'rs.name'},
            { data: 'business_location', name: 'bl.name'},
            { data: 'warranty_name', name: 'rw.name'},
            { data: 'payment_status', name: 'payment_status'},
            { data: 'final_total', name: 'final_total', orderable: false, searchable: false},
            { data: 'total_remaining', name: 'total_remaining', orderable: false, searchable: false},
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ],
        "fnDrawCallback": function (oSettings) {

            $('#footer_sale_total').text(sum_table_col($('#sell_table'), 'final-total'));

            $('#footer_total_remaining').text(sum_table_col($('#sell_table'), 'payment_due'));

            $('#footer_total_sell_return_due').text(sum_table_col($('#sell_table'), 'sell_return_due'));

            $('#footer_payment_status_count').html(__sum_status_html($('#sell_table'), 'payment-status-label'));

            $('#footer_repair_status_count').html(__sum_status_html($('#sell_table'), 'edit_repair_status'));

            __currency_convert_recursively($('#sell_table'));
        },
        createdRow: function( row, data, dataIndex ) {
            $( row ).find('td:eq(7)').attr('class', 'clickable_td');
            $( row ).find('td:eq(4)').attr('class', 'clickable_td edit_status_td');
        }
    });

    $(document).on('change', '#sell_list_filter_location_id, #sell_list_filter_customer_id, #sell_list_filter_payment_status, #service_staff_id, #repair_status_id',  function() {
        sell_table.ajax.reload();
    });
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check("repair_status.update")): ?>
        $(document).on('click', '.edit_repair_status, .edit_status_td', function(e){
            e.preventDefault();
            var link = $(this);
            if($(this).hasClass('edit_status_td')) {
                link = $(this).find('a');
            }
            var repair_no = link.data('repair_no');
            var repair_id = link.data('repair_id');
            var repair_status_id = link.data('repair_status_id');
            $('#edit_repair_status_modal').find('#repair_no').text(repair_no);
            $('#edit_repair_status_modal').find('#repair_id').val(repair_id);
            $('#edit_repair_status_modal').find('#update_note').val('');
            $('#edit_repair_status_modal').find('#repair_status_id_modal').val(repair_status_id).change();
            $('#edit_repair_status_modal').modal('show');
        });
    <?php endif; ?>

    $(document).on('submit', 'form#update_repair_status_form', function(e){
        e.preventDefault();
        var data = $(this).serialize();

        $.ajax({
            method: $(this).attr("method"),
            url: $(this).attr("action"),
            dataType: "json",
            data: data,
            success: function(result){
                if(result.success == true){
                    $('#edit_repair_status_modal').modal('hide');
                    toastr.success(result.msg);
                    sell_table.ajax.reload();
                } else {
                    toastr.error(result.msg);
                }
            }
        });
    });

    $(document).on('click', '.delete_media', function(e){
        e.preventDefault();
        var this_btn = $(this);
        $.ajax({
            url: $(this).attr("href"),
            dataType: "json",
            success: function(result){
                if(result.success == true){
                    this_btn.closest('tr').remove();
                    toastr.success(result.msg);
                } else {
                    toastr.error(result.msg);
                }
            }
        });
    });
    $(document).on('click', '.collapsed-box-title', function(e){
        if (e.target.tagName == 'BUTTON' || e.target.tagName == 'I') {
            return false;
        }
        $(this).find('.box-tools button').click();
    });

});
</script>
<script src="<?php echo e(asset('js/payment.js?v=' . $asset_v)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>