<?php $__env->startSection('title', __('repair::lang.repair_warranty')); ?>

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/bootstrap-colorpicker/bootstrap-colorpicker.min.css')); ?>">

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('repair::lang.repair_warranty')); ?>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'repair::lang.all_repair_warranties' )]); ?>
        <?php $__env->slot('tool'); ?>
            <div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                    data-href="<?php echo e(action('\Modules\Repair\Http\Controllers\WarrantyController@create')); ?>" 
                    data-container=".view_modal">
                    <i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson( 'messages.add' )); ?></button>
            </div>
        <?php $__env->endSlot(); ?>
        <table class="table table-bordered table-striped" id="warranty_table">
            <thead>
                <tr>
                    <th><?php echo e(app('translator')->getFromJson( 'lang_v1.name' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'lang_v1.description' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'repair::lang.duration' )); ?></th>
                    <th><?php echo e(app('translator')->getFromJson( 'messages.action' )); ?></th>
                </tr>
            </thead>
        </table>
    <?php echo $__env->renderComponent(); ?>

    <div class="modal fade brands_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('plugins/bootstrap-colorpicker/bootstrap-colorpicker.min.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready( function(){
        //Status table
        var warranty_table = $('#warranty_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(action('\Modules\Repair\Http\Controllers\WarrantyController@index')); ?>",
                columnDefs: [ {
                    "targets": 3,
                    "orderable": false,
                    "searchable": false
                } ],
                columns: [
                    { data: 'name', name: 'name' },
                    { data: 'description', name: 'description' },
                    { data: 'duration', name: 'duration' },
                    { data: 'action', name: 'action' },
                ]
            });

        $(document).on('submit', 'form#warranty_form', function(e){
            e.preventDefault();
            $(this).find('button[type="submit"]').attr('disabled', true);
            var data = $(this).serialize();

            $.ajax({
                method: $(this).attr('method'),
                url: $(this).attr("action"),
                dataType: "json",
                data: data,
                success: function(result){
                    if(result.success == true){
                        $('div.view_modal').modal('hide');
                        toastr.success(result.msg);
                        warranty_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>