<?php $__env->startSection('title', __('ecommerce::lang.shipping')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('ecommerce::lang.shipping')); ?>
    <small><?php echo e(app('translator')->getFromJson('ecommerce::lang.add_or_edit_shipping_class_and_shipping_zone')); ?></small></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-xs-12">
           <!--  <pos-tab-container> -->
            <div class="col-xs-12 pos-tab-container">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 pos-tab-menu">
                    <div class="list-group">
                        <a href="#" class="list-group-item text-center active"><?php echo e(app('translator')->getFromJson('ecommerce::lang.shipping_zones')); ?></a>
                        <a href="#" class="list-group-item text-center"><?php echo e(app('translator')->getFromJson('ecommerce::lang.shipping_classes')); ?></a>
                    </div>
                </div>
                <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 pos-tab">
                    <?php echo $__env->make('ecommerce::settings.partials.shipping_zones', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php echo $__env->make('ecommerce::settings.partials.shipping_classes', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
            </div>
            <!--  </pos-tab-container> -->
        </div>
    </div>
</section>
<div class="modal fade" id="add_shipping_class_modal" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
    <?php echo $__env->make('ecommerce::shipping_class.create', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<div class="modal fade" id="edit_shipping_class_modal" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel"></div>
<div class="modal fade" id="shipping_zone_modal" tabindex="-1" role="dialog"></div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
    $(document).ready( function() {
        var shipping_classes_table = $('#shipping_classes_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '/ecommerce/shipping-class',
            columnDefs: [ {
                "targets": 1,
                "orderable": false,
                "searchable": false
            } ]
        });
        $(document).on('submit', 'form#add_shipping_class_form, form#edit_shipping_class_form', function (e) {
            e.preventDefault();
            var data = $(this).serialize();
            $.ajax({
                method: $(this).attr("method"),
                url: $(this).attr("action"),
                dataType: "json",
                data: data,
                success: function(result){
                    if(result.success == true){
                        $('div#add_shipping_class_modal').modal('hide');
                        $('div#edit_shipping_class_modal').modal('hide');
                        $('form#add_shipping_class_form')[0].reset();
                        toastr.success(result.msg);
                        shipping_classes_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                }
            });
        });

        var shipping_zones_table = $('#shipping_zones_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '/ecommerce/shipping-zone',
            columnDefs: [ {
                "targets": [4, 5],
                "orderable": false,
                "searchable": false
            } ],
            columns: [
                {data: 'name', name: 'name'},
                {data: 'country', name: 'country'},
                {data: 'state', name: 'state'},
                {data: 'city', name: 'city'},
                {data: 'shipping_prices', name: 'shipping_prices'},
                {data: 'action', name: 'action'}
            ],
            "fnDrawCallback": function (oSettings) {
                __currency_convert_recursively($('#shipping_zones_table'));
            }
        });

        $(document).on('submit', 'form#add_shipping_zone_form, form#edit_shipping_zone_form', function (e) {
            e.preventDefault();
            var data = $(this).serialize();
            $.ajax({
                method: $(this).attr("method"),
                url: $(this).attr("action"),
                dataType: "json",
                data: data,
                success: function(result){
                    if(result.success == true){
                        $('div#shipping_zone_modal').modal('hide');
                        toastr.success(result.msg);
                        shipping_zones_table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>