<?php $__env->startSection('title', __('essentials::lang.attendance')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1><?php echo e(app('translator')->getFromJson('essentials::lang.attendance')); ?>
    </h1>
</section>
<!-- Main content -->
<section class="content">
    <?php if($is_employee_allowed && !$is_admin): ?>
        <div class="row">
            <div class="col-md-12 text-center">
                <button 
                    type="button" 
                    class="btn btn-app bg-blue clock_in_btn
                        <?php if(!empty($clock_in)): ?>
                            hide
                        <?php endif; ?>
                    "
                    data-type="clock_in"
                    >
                    <i class="fa fa-arrow-circle-down"></i> <?php echo e(app('translator')->getFromJson('essentials::lang.clock_in')); ?>
                </button>
            &nbsp;&nbsp;&nbsp;
                <button 
                    type="button" 
                    class="btn btn-app bg-yellow clock_out_btn
                        <?php if(empty($clock_in)): ?>
                            hide
                        <?php endif; ?>
                    "  
                    data-type="clock_out"
                    >
                    <i class="fa fa-arrow-circle-up"></i> <?php echo e(app('translator')->getFromJson('essentials::lang.clock_out')); ?>
                </button>
                <?php if(!empty($clock_in)): ?>
                    <br>
                    <small class="text-muted"><?php echo e(app('translator')->getFromJson('essentials::lang.clocked_in_at')); ?>: <?php echo e(\Carbon::createFromTimestamp(strtotime($clock_in->clock_in_time))->format(session('business.date_format') . ' ' . 'H:i')); ?></small>
                <?php endif; ?>
            </div>
        </div>
        <br>
    <?php endif; ?>
    <div class="row">
        <div class="col-md-12">
        <?php $__env->startComponent('components.filters', ['title' => __('report.filters'), 'closed' => true]); ?>
            <?php if($is_admin): ?>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('employee_id', __('essentials::lang.employee') . ':'); ?>

                        <?php echo Form::select('employee_id', $employees, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all')]);; ?>

                    </div>
                </div>
            <?php endif; ?>
            <div class="col-md-3">
                <div class="form-group">
                    <?php echo Form::label('date_range', __('report.date_range') . ':'); ?>

                    <?php echo Form::text('date_range', null, ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'readonly']);; ?>

                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'essentials::lang.all_attendance' )]); ?>
                <?php if($is_admin): ?>
                    <?php $__env->slot('tool'); ?>
                        <div class="box-tools">
                            <button type="button" class="btn btn-block btn-primary btn-modal" data-href="<?php echo e(action('\Modules\Essentials\Http\Controllers\AttendanceController@create')); ?>" data-container="#attendance_modal">
                                <i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson( 'messages.add' )); ?></button>
                        </div>
                    <?php $__env->endSlot(); ?>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="attendance_table">
                        <thead>
                            <tr>
                                <th><?php echo e(app('translator')->getFromJson( 'lang_v1.date' )); ?></th>
                                <th><?php echo e(app('translator')->getFromJson('essentials::lang.employee')); ?></th>
                                <th><?php echo e(app('translator')->getFromJson('essentials::lang.clock_in_clock_out')); ?></th>
                                <th><?php echo e(app('translator')->getFromJson('essentials::lang.ip_address')); ?></th>
                                <th><?php echo e(app('translator')->getFromJson('essentials::lang.clock_in_note')); ?></th>
                                <th><?php echo e(app('translator')->getFromJson('essentials::lang.clock_out_note')); ?></th>
                                <?php if($is_admin): ?>
                                    <th><?php echo e(app('translator')->getFromJson( 'messages.action' )); ?></th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                    </table>
                </div>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade" id="attendance_modal" tabindex="-1" role="dialog" 
        aria-labelledby="gridSystemModalLabel"></div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            attendance_table = $('#attendance_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    "url": "<?php echo e(action('\Modules\Essentials\Http\Controllers\AttendanceController@index')); ?>",
                    "data" : function(d) {
                        if ($('#employee_id').length) {
                            d.employee_id = $('#employee_id').val();
                        }
                        if($('#date_range').val()) {
                            var start = $('#date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                            var end = $('#date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                            d.start_date = start;
                            d.end_date = end;
                        }
                    }
                },
                columns: [
                    { data: 'date', name: 'clock_in_time' },
                    { data: 'user', name: 'user' },
                    { data: 'clock_in_clock_out', name: 'clock_in_time' },
                    { data: 'ip_address', name: 'ip_address'},
                    { data: 'clock_in_note', name: 'clock_in_note'},
                    { data: 'clock_out_note', name: 'clock_out_note'},
                    <?php if($is_admin): ?>
                        { data: 'action', name: 'action', orderable: false, searchable: false},
                    <?php endif; ?>
                ],
            });

            $('#date_range').daterangepicker(
                dateRangeSettings,
                function (start, end) {
                    $('#date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
                    attendance_table.ajax.reload();
                }
            );
            $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
                $('#date_range').val('');
                attendance_table.ajax.reload();
            });

            $(document).on('change', '#employee_id, #date_filter', function() {
                attendance_table.ajax.reload();
            });

            $(document).on('submit', 'form#attendance_form', function(e) {
                e.preventDefault();
                $(this).find('button[type="submit"]').attr('disabled', true);
                var data = $(this).serialize();

                $.ajax({
                    method: $(this).attr('method'),
                    url: $(this).attr('action'),
                    dataType: 'json',
                    data: data,
                    success: function(result) {
                        if (result.success == true) {
                            $('div#attendance_modal').modal('hide');
                            toastr.success(result.msg);
                            attendance_table.ajax.reload();
                        } else {
                            toastr.error(result.msg);
                        }
                    },
                });
            });
        });

        $(document).on('click', 'button.delete-attendance', function() {
            swal({
                title: LANG.sure,
                icon: 'warning',
                buttons: true,
                dangerMode: true,
            }).then(willDelete => {
                if (willDelete) {
                    var href = $(this).data('href');
                    var data = $(this).serialize();
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        dataType: 'json',
                        data: data,
                        success: function(result) {
                            if (result.success == true) {
                                toastr.success(result.msg);
                                attendance_table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        },
                    });
                }
            });
        });

        $('#attendance_modal').on('shown.bs.modal', function(e) {
            $('#attendance_modal #employees').select2();
            $('#attendance_modal #clock_in_time, #attendance_modal #clock_out_time').datetimepicker({
                format: moment_date_format + ' ' + moment_time_format,
                ignoreReadonly: true,
            });
            $('form#attendance_form').validate();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>