
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type` enum('saving_current','capital') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','edited',11,'App\\Transaction',1,'App\\User','[]','2020-01-27 05:31:29','2020-01-27 05:31:29');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 11:13:44','2017-12-18 11:13:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 11:04:39','2017-12-18 11:10:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 10:55:40','2017-12-18 10:55:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 10:58:40','2017-12-18 10:58:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Dell','Dell Laptop',1,NULL,'2020-01-27 03:37:28','2020-01-27 03:37:28'),(2,1,'HP','HP Laptop',1,NULL,'2020-01-27 03:37:51','2020-01-27 03:37:51'),(3,1,'ASUS','ASUS Laptop',1,NULL,'2020-01-27 03:38:17','2020-01-27 03:38:17'),(4,1,'Remax','Remax 10000mah',1,NULL,'2020-01-27 04:02:07','2020-01-27 04:02:07'),(5,1,'Colling Fan Special','Colling Fan Special',1,NULL,'2020-01-27 04:20:09','2020-01-27 04:20:09'),(6,1,'Processor','Processor Core2 due',1,NULL,'2020-01-27 04:26:41','2020-01-27 04:26:41'),(7,1,'Colling Fan','Colling Fan Normal',1,NULL,'2020-01-27 04:34:44','2020-01-27 04:34:44'),(8,1,'Laptop Power Cable','Laptop Power Cable',1,NULL,'2020-01-27 04:35:52','2020-01-27 04:35:52'),(9,1,'VGA Cable','VGA Cable',1,NULL,'2020-01-27 20:43:31','2020-01-27 20:43:31'),(10,1,'Power Cable','Power Cable',1,NULL,'2020-01-27 20:48:31','2020-01-27 20:48:31'),(11,1,'Mother Board','Mother Board 81 Asus',1,NULL,'2020-01-27 20:52:33','2020-01-27 20:52:33'),(12,1,'RAM DDR 3 4 GB','RAM DDR 3 4 GB',1,NULL,'2020-01-27 20:57:17','2020-01-27 20:57:17'),(13,1,'RAM DDR 3 8 GB','RAM DDR 3 8 GB',1,NULL,'2020-01-27 20:59:10','2020-01-27 20:59:10'),(14,1,'SSD 120 GB','SSD 120 GB',1,NULL,'2020-01-27 21:01:22','2020-01-27 21:01:22'),(15,1,'HDD 500 GB','HDD 500 GB',1,NULL,'2020-01-27 21:03:22','2020-01-27 21:03:22'),(16,1,'HDD 320 GB','HDD 320 GB',1,NULL,'2020-01-27 21:05:12','2020-01-27 21:05:12'),(17,1,'HDD 250 GB','HDD 250 GB',1,NULL,'2020-01-27 21:06:44','2020-01-27 21:06:44'),(18,1,'Mobile Charger','Mobile Charger (Active)',1,NULL,'2020-01-27 21:09:09','2020-01-27 21:09:09'),(19,1,'Mobile Charger (Excel)','Mobile Charger (Excel)',1,NULL,'2020-01-27 21:10:51','2020-01-27 21:10:51'),(20,1,'Mobile Stand','Mobile Stand',1,NULL,'2020-01-27 22:32:33','2020-01-27 22:32:33'),(21,1,'Router TP Link WR841','Router TP Link WR841',1,NULL,'2020-01-27 22:36:35','2020-01-27 22:36:35'),(22,1,'Router TP Link WR840','Router TP Link WR840',1,NULL,'2020-01-27 22:40:45','2020-01-27 22:40:45'),(23,1,'Router Mercusys MW301R','Router Mercusys MW301R',1,NULL,'2020-01-27 22:47:20','2020-01-27 22:47:20'),(24,1,'Router Tenda F3','Router Tenda F3',1,NULL,'2020-01-27 22:50:47','2020-01-27 22:50:47'),(25,1,'Land Card','Land Card',1,NULL,'2020-01-27 22:56:11','2020-01-27 22:56:11'),(26,1,'Usb Land Card','Usb Land Card',1,NULL,'2020-01-27 22:57:57','2020-01-27 22:57:57'),(27,1,'land card totolink','land card totolink',1,NULL,'2020-01-27 23:02:38','2020-01-27 23:02:38'),(28,1,'Samsung Mobile Charger Adopter','Samsung Mobile Charger Adopter',1,NULL,'2020-01-27 23:05:22','2020-01-27 23:05:22'),(29,1,'VNC Connector','VNC Connector',1,NULL,'2020-01-27 23:08:25','2020-01-27 23:08:25'),(30,1,'CCTV ADOPTER','CCTV ADOPTER',1,NULL,'2020-01-27 23:10:57','2020-01-27 23:10:57'),(31,1,'Valutop CCTV ADOPTER','Valutop CCTV ADOPTER',1,NULL,'2020-01-27 23:12:48','2020-01-27 23:12:48'),(32,1,'Valuetop CCTV ADOPTER','Valuetop CCTV ADOPTER',1,NULL,'2020-01-27 23:15:00','2020-01-27 23:15:00'),(33,1,'Keyboard fast key','Keyboard fast key',1,NULL,'2020-01-27 23:17:55','2020-01-27 23:17:55'),(34,1,'Keyboard Suntech','Keyboard Suntech',1,NULL,'2020-01-27 23:20:03','2020-01-27 23:20:03'),(35,1,'Keyboard A4tech','Keyboard A4tech',1,NULL,'2020-01-27 23:24:09','2020-01-27 23:24:09'),(36,1,'keyboard logitech usb k120','keyboard logitech usb k120',1,NULL,'2020-01-27 23:27:25','2020-01-27 23:27:25'),(37,1,'USB Speaker D9','USB Speaker D9',1,NULL,'2020-01-27 23:29:33','2020-01-27 23:29:33'),(38,1,'USB Speaker D7','USB Speaker D7',1,NULL,'2020-01-27 23:34:55','2020-01-27 23:34:55'),(39,1,'USB Speaker D10','USB Speaker D10',1,NULL,'2020-01-27 23:38:05','2020-01-27 23:38:05'),(40,1,'ezviz camera','ezviz camera',1,NULL,'2020-01-27 23:40:49','2020-01-27 23:40:49'),(41,1,'active charger u143k','active charger u143k',1,NULL,'2020-01-27 23:52:11','2020-01-27 23:52:11'),(42,1,'Data Cable','Data Cable',1,NULL,'2020-01-27 23:56:10','2020-01-27 23:56:10'),(43,1,'Usb Sound Card','Usb Sound Card',1,NULL,'2020-01-28 03:08:00','2020-01-28 03:08:00'),(44,1,'Mouse Astrum','Mouse Astrum',1,NULL,'2020-01-28 03:11:09','2020-01-28 03:11:09'),(45,1,'Mouse Havit','Mouse Havit',1,NULL,'2020-01-28 03:15:05','2020-01-28 03:15:05'),(46,1,'Mouse Fastkey','Mouse Fastkey',1,NULL,'2020-01-28 03:17:42','2020-01-28 03:17:42'),(47,1,'Mouse Micropack','Mouse Micropack',1,NULL,'2020-01-28 03:20:18','2020-01-28 03:20:18'),(48,1,'Mouse Delux','Mouse Delux',1,NULL,'2020-01-28 03:23:21','2020-01-28 03:23:21'),(49,1,'Mouse Delux M107 Wireless','Mouse Delux M107 Wireless',1,NULL,'2020-01-28 03:26:13','2020-01-28 03:26:13'),(50,1,'Mouse Gaming','Mouse Gaming',1,NULL,'2020-01-28 03:29:57','2020-01-28 03:29:57'),(51,1,'Mouse Zornwee','Mouse Zornwee',1,NULL,'2020-01-28 03:33:19','2020-01-28 03:33:19'),(52,1,'Mouse Havit Gaming','Mouse Havit Gaming',1,NULL,'2020-01-28 03:35:07','2020-01-28 03:35:07'),(53,1,'Mouse W4 Wireless','Mouse W4 Wireless',1,NULL,'2020-01-28 03:37:25','2020-01-28 03:37:25'),(54,1,'vr box','vr box',1,NULL,'2020-01-28 03:40:01','2020-01-28 03:40:01'),(55,1,'Joystick','joystick',1,NULL,'2020-01-29 21:21:20','2020-01-29 21:21:20'),(56,1,'Bluetooth headset','Bluetooth headset',1,NULL,'2020-01-29 21:26:27','2020-01-29 21:26:27'),(57,1,'Excel Mobile Charger','Excel Mobile Charger',1,NULL,'2020-01-29 21:34:50','2020-01-29 21:34:50'),(58,1,'Secondary HDD Caddy','Secondary HDD Caddy',1,NULL,'2020-01-29 21:38:49','2020-01-29 21:38:49'),(59,1,'Uiisii u7 head phone','Uiisii u7 head phone',1,NULL,'2020-01-29 21:50:15','2020-01-29 21:50:15'),(60,1,'Remax RM 512','Remax RM 512',1,NULL,'2020-01-29 21:56:44','2020-01-29 21:56:44'),(61,1,'Wireless Mouse','Wireless Mouse',1,NULL,'2020-01-29 22:15:11','2020-01-29 22:15:11'),(62,1,'Remax Data Cable','Remax Data Cable',1,NULL,'2020-01-29 22:19:25','2020-01-29 22:19:25'),(63,1,'Mobile Battery Excel','Mobile Battery Excel',1,NULL,'2020-01-29 22:24:38','2020-01-29 22:24:38'),(64,1,'A4tech mouse','A4tech mouse',1,NULL,'2020-01-29 22:43:26','2020-01-29 22:43:26'),(65,1,'Asus mouse','Asus mouse',1,NULL,'2020-01-29 22:47:29','2020-01-29 22:47:29'),(66,1,'Havit Wireless Mouse','Havit Wireless Mouse',1,NULL,'2020-01-29 22:49:25','2020-01-29 22:49:25'),(67,1,'bluetooth headphones sport','bluetooth headphones sport',1,NULL,'2020-01-29 22:52:59','2020-01-29 22:52:59'),(68,1,'OTG Cable','OTG Cable',1,NULL,'2020-01-29 22:57:11','2020-01-29 22:57:11'),(69,1,'OTG Remax','OTG Remax',1,NULL,'2020-01-29 22:59:26','2020-01-29 22:59:26'),(70,1,'USB Half P-1703','USB Half P-1703',1,NULL,'2020-01-29 23:07:12','2020-01-29 23:07:12'),(71,1,'usb half 4port p-1601','usb half 4port p-1601',1,NULL,'2020-01-29 23:09:39','2020-01-29 23:09:39'),(72,1,'usb half 4port u 3.0','usb half 4port u 3.0',1,NULL,'2020-01-29 23:13:27','2020-01-29 23:13:27'),(73,1,'usb half 4port u 3.0 120cm','usb half 4port u 3.0 120cm',1,NULL,'2020-01-29 23:15:54','2020-01-29 23:15:54'),(74,1,'Bluetooth Speaker  nbs-14','Bluetooth Speaker  nbs-14',1,NULL,'2020-01-29 23:32:12','2020-01-29 23:32:12'),(75,1,'Bluetooth Speaker  HS-016','Bluetooth Speaker  HS-016',1,NULL,'2020-01-29 23:36:27','2020-01-29 23:36:27'),(76,1,'Bluetooth Speaker','Bluetooth Speaker',1,NULL,'2020-01-29 23:51:33','2020-01-29 23:51:33'),(77,1,'Bluetooth Speaker u-2500bt image','Bluetooth Speaker u-2500bt image',1,NULL,'2020-01-29 23:58:44','2020-01-29 23:58:44'),(78,1,'Bluetooth Speaker x7reem2 mini','Bluetooth Speaker x7reem2 mini',1,NULL,'2020-01-30 00:04:43','2020-01-30 00:04:43'),(79,1,'Bluetooth Speaker new Rixing  RN-2010','Bluetooth Speaker new Rixing  RN-2010',1,NULL,'2020-01-30 00:07:28','2020-01-30 00:07:28'),(80,1,'Bluetooth Speaker s815','Bluetooth Speaker s815',1,NULL,'2020-01-30 00:10:56','2020-01-30 00:10:56'),(81,1,'Bluetooth Speaker KTX-1057','Bluetooth Speaker KTX-1057',1,NULL,'2020-01-30 00:13:34','2020-01-30 00:13:34'),(82,1,'Bluetooth Speaker was- 842','Bluetooth Speaker was- 842',1,NULL,'2020-01-30 00:16:02','2020-01-30 00:16:02'),(83,1,'Bluetooth Speaker was- 837','Bluetooth Speaker was- 837',1,NULL,'2020-01-30 00:17:18','2020-01-30 00:17:18'),(84,1,'Bluetooth Speaker K5','Bluetooth Speaker K5',1,NULL,'2020-01-30 00:19:44','2020-01-30 00:19:44'),(85,1,'BIOS Battery','BIOS Battery',1,NULL,'2020-01-30 03:33:23','2020-01-30 03:33:23');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Ray Computer & Electronics',134,'2020-01-26',NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"is_pos_subtotal_editable\":\"1\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}',1,'2020-01-27 03:00:32','2020-01-27 20:47:36');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','Ray Computer & Electronics','Shop No -48, Molla Super Market, Charagali','Bangladesh','Gazipur','Tongi','1710',1,1,1,'browser',NULL,'01635009232',NULL,NULL,'http://bestsmartsecuritycamera.com','Multi-Cuisine Restaurant & Party Center',NULL,NULL,NULL,NULL,'2020-01-27 03:00:32','2020-01-27 21:57:54');
