
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type` enum('saving_current','capital') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','edited',11,'App\\Transaction',1,'App\\User','[]','2020-01-27 05:31:29','2020-01-27 05:31:29'),(2,'default','edited',126,'App\\Transaction',1,'App\\User','[]','2020-01-30 20:29:54','2020-01-30 20:29:54'),(3,'default','edited',132,'App\\Transaction',1,'App\\User','[]','2020-01-31 18:08:46','2020-01-31 18:08:46'),(4,'default','edited',136,'App\\Transaction',1,'App\\User','[]','2020-01-31 18:35:22','2020-01-31 18:35:22'),(5,'default','edited',148,'App\\Transaction',1,'App\\User','[]','2020-02-01 22:41:29','2020-02-01 22:41:29');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 11:13:44','2017-12-18 11:13:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 11:04:39','2017-12-18 11:10:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 10:55:40','2017-12-18 10:55:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 10:58:40','2017-12-18 10:58:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Dell','Dell Laptop',1,NULL,'2020-01-27 03:37:28','2020-01-27 03:37:28'),(2,1,'HP','HP Laptop',1,NULL,'2020-01-27 03:37:51','2020-01-27 03:37:51'),(3,1,'ASUS','ASUS Laptop',1,NULL,'2020-01-27 03:38:17','2020-01-27 03:38:17'),(4,1,'Remax','Remax 10000mah',1,NULL,'2020-01-27 04:02:07','2020-01-27 04:02:07'),(5,1,'Colling Fan Special','Colling Fan Special',1,NULL,'2020-01-27 04:20:09','2020-01-27 04:20:09'),(6,1,'Processor','Processor Core2 due',1,NULL,'2020-01-27 04:26:41','2020-01-27 04:26:41'),(7,1,'Colling Fan','Colling Fan Normal',1,NULL,'2020-01-27 04:34:44','2020-01-27 04:34:44'),(8,1,'Laptop Power Cable','Laptop Power Cable',1,NULL,'2020-01-27 04:35:52','2020-01-27 04:35:52'),(9,1,'VGA Cable','VGA Cable',1,NULL,'2020-01-27 20:43:31','2020-01-27 20:43:31'),(10,1,'Power Cable','Power Cable',1,NULL,'2020-01-27 20:48:31','2020-01-27 20:48:31'),(11,1,'Mother Board','Mother Board 81 Asus',1,NULL,'2020-01-27 20:52:33','2020-01-27 20:52:33'),(12,1,'RAM DDR 3 4 GB','RAM DDR 3 4 GB',1,NULL,'2020-01-27 20:57:17','2020-01-27 20:57:17'),(13,1,'RAM DDR 3 8 GB','RAM DDR 3 8 GB',1,NULL,'2020-01-27 20:59:10','2020-01-27 20:59:10'),(14,1,'SSD 120 GB','SSD 120 GB',1,NULL,'2020-01-27 21:01:22','2020-01-27 21:01:22'),(15,1,'HDD 500 GB','HDD 500 GB',1,NULL,'2020-01-27 21:03:22','2020-01-27 21:03:22'),(16,1,'HDD 320 GB','HDD 320 GB',1,NULL,'2020-01-27 21:05:12','2020-01-27 21:05:12'),(17,1,'HDD 250 GB','HDD 250 GB',1,NULL,'2020-01-27 21:06:44','2020-01-27 21:06:44'),(18,1,'Mobile Charger','Mobile Charger (Active)',1,NULL,'2020-01-27 21:09:09','2020-01-27 21:09:09'),(19,1,'Mobile Charger (Excel)','Mobile Charger (Excel)',1,NULL,'2020-01-27 21:10:51','2020-01-27 21:10:51'),(20,1,'Mobile Stand','Mobile Stand',1,NULL,'2020-01-27 22:32:33','2020-01-27 22:32:33'),(21,1,'Router TP Link WR841','Router TP Link WR841',1,NULL,'2020-01-27 22:36:35','2020-01-27 22:36:35'),(22,1,'Router TP Link WR840','Router TP Link WR840',1,NULL,'2020-01-27 22:40:45','2020-01-27 22:40:45'),(23,1,'Router Mercusys MW301R','Router Mercusys MW301R',1,NULL,'2020-01-27 22:47:20','2020-01-27 22:47:20'),(24,1,'Router Tenda F3','Router Tenda F3',1,NULL,'2020-01-27 22:50:47','2020-01-27 22:50:47'),(25,1,'Land Card','Land Card',1,NULL,'2020-01-27 22:56:11','2020-01-27 22:56:11'),(26,1,'Usb Land Card','Usb Land Card',1,NULL,'2020-01-27 22:57:57','2020-01-27 22:57:57'),(27,1,'land card totolink','land card totolink',1,NULL,'2020-01-27 23:02:38','2020-01-27 23:02:38'),(28,1,'Samsung Mobile Charger Adopter','Samsung Mobile Charger Adopter',1,NULL,'2020-01-27 23:05:22','2020-01-27 23:05:22'),(29,1,'VNC Connector','VNC Connector',1,NULL,'2020-01-27 23:08:25','2020-01-27 23:08:25'),(30,1,'CCTV ADOPTER','CCTV ADOPTER',1,NULL,'2020-01-27 23:10:57','2020-01-27 23:10:57'),(31,1,'Valutop CCTV ADOPTER','Valutop CCTV ADOPTER',1,NULL,'2020-01-27 23:12:48','2020-01-27 23:12:48'),(32,1,'Valuetop CCTV ADOPTER','Valuetop CCTV ADOPTER',1,NULL,'2020-01-27 23:15:00','2020-01-27 23:15:00'),(33,1,'Keyboard fast key','Keyboard fast key',1,NULL,'2020-01-27 23:17:55','2020-01-27 23:17:55'),(34,1,'Keyboard Suntech','Keyboard Suntech',1,NULL,'2020-01-27 23:20:03','2020-01-27 23:20:03'),(35,1,'Keyboard A4tech','Keyboard A4tech',1,NULL,'2020-01-27 23:24:09','2020-01-27 23:24:09'),(36,1,'keyboard logitech usb k120','keyboard logitech usb k120',1,NULL,'2020-01-27 23:27:25','2020-01-27 23:27:25'),(37,1,'USB Speaker D9','USB Speaker D9',1,NULL,'2020-01-27 23:29:33','2020-01-27 23:29:33'),(38,1,'USB Speaker D7','USB Speaker D7',1,NULL,'2020-01-27 23:34:55','2020-01-27 23:34:55'),(39,1,'USB Speaker D10','USB Speaker D10',1,NULL,'2020-01-27 23:38:05','2020-01-27 23:38:05'),(40,1,'ezviz camera','ezviz camera',1,NULL,'2020-01-27 23:40:49','2020-01-27 23:40:49'),(41,1,'active charger u143k','active charger u143k',1,NULL,'2020-01-27 23:52:11','2020-01-27 23:52:11'),(42,1,'Data Cable','Data Cable',1,NULL,'2020-01-27 23:56:10','2020-01-27 23:56:10'),(43,1,'Usb Sound Card','Usb Sound Card',1,NULL,'2020-01-28 03:08:00','2020-01-28 03:08:00'),(44,1,'Mouse Astrum','Mouse Astrum',1,NULL,'2020-01-28 03:11:09','2020-01-28 03:11:09'),(45,1,'Mouse Havit','Mouse Havit',1,NULL,'2020-01-28 03:15:05','2020-01-28 03:15:05'),(46,1,'Mouse Fastkey','Mouse Fastkey',1,NULL,'2020-01-28 03:17:42','2020-01-28 03:17:42'),(47,1,'Mouse Micropack','Mouse Micropack',1,NULL,'2020-01-28 03:20:18','2020-01-28 03:20:18'),(48,1,'Mouse Delux','Mouse Delux',1,NULL,'2020-01-28 03:23:21','2020-01-28 03:23:21'),(49,1,'Mouse Delux M107 Wireless','Mouse Delux M107 Wireless',1,NULL,'2020-01-28 03:26:13','2020-01-28 03:26:13'),(50,1,'Mouse Gaming','Mouse Gaming',1,NULL,'2020-01-28 03:29:57','2020-01-28 03:29:57'),(51,1,'Mouse Zornwee','Mouse Zornwee',1,NULL,'2020-01-28 03:33:19','2020-01-28 03:33:19'),(52,1,'Mouse Havit Gaming','Mouse Havit Gaming',1,NULL,'2020-01-28 03:35:07','2020-01-28 03:35:07'),(53,1,'Mouse W4 Wireless','Mouse W4 Wireless',1,NULL,'2020-01-28 03:37:25','2020-01-28 03:37:25'),(54,1,'vr box','vr box',1,NULL,'2020-01-28 03:40:01','2020-01-28 03:40:01'),(55,1,'Joystick','joystick',1,NULL,'2020-01-29 21:21:20','2020-01-29 21:21:20'),(56,1,'Bluetooth headset','Bluetooth headset',1,NULL,'2020-01-29 21:26:27','2020-01-29 21:26:27'),(57,1,'Excel Mobile Charger','Excel Mobile Charger',1,NULL,'2020-01-29 21:34:50','2020-01-29 21:34:50'),(58,1,'Secondary HDD Caddy','Secondary HDD Caddy',1,NULL,'2020-01-29 21:38:49','2020-01-29 21:38:49'),(59,1,'Uiisii u7 head phone','Uiisii u7 head phone',1,NULL,'2020-01-29 21:50:15','2020-01-29 21:50:15'),(60,1,'Remax RM 512','Remax RM 512',1,NULL,'2020-01-29 21:56:44','2020-01-29 21:56:44'),(61,1,'Wireless Mouse','Wireless Mouse',1,NULL,'2020-01-29 22:15:11','2020-01-29 22:15:11'),(62,1,'Remax Data Cable','Remax Data Cable',1,NULL,'2020-01-29 22:19:25','2020-01-29 22:19:25'),(63,1,'Mobile Battery Excel','Mobile Battery Excel',1,NULL,'2020-01-29 22:24:38','2020-01-29 22:24:38'),(64,1,'A4tech mouse','A4tech mouse',1,NULL,'2020-01-29 22:43:26','2020-01-29 22:43:26'),(65,1,'Asus mouse','Asus mouse',1,NULL,'2020-01-29 22:47:29','2020-01-29 22:47:29'),(66,1,'Havit Wireless Mouse','Havit Wireless Mouse',1,NULL,'2020-01-29 22:49:25','2020-01-29 22:49:25'),(67,1,'bluetooth headphones sport','bluetooth headphones sport',1,NULL,'2020-01-29 22:52:59','2020-01-29 22:52:59'),(68,1,'OTG Cable','OTG Cable',1,NULL,'2020-01-29 22:57:11','2020-01-29 22:57:11'),(69,1,'OTG Remax','OTG Remax',1,NULL,'2020-01-29 22:59:26','2020-01-29 22:59:26'),(70,1,'USB Half P-1703','USB Half P-1703',1,NULL,'2020-01-29 23:07:12','2020-01-29 23:07:12'),(71,1,'usb half 4port p-1601','usb half 4port p-1601',1,NULL,'2020-01-29 23:09:39','2020-01-29 23:09:39'),(72,1,'usb half 4port u 3.0','usb half 4port u 3.0',1,NULL,'2020-01-29 23:13:27','2020-01-29 23:13:27'),(73,1,'usb half 4port u 3.0 120cm','usb half 4port u 3.0 120cm',1,NULL,'2020-01-29 23:15:54','2020-01-29 23:15:54'),(74,1,'Bluetooth Speaker  nbs-14','Bluetooth Speaker  nbs-14',1,NULL,'2020-01-29 23:32:12','2020-01-29 23:32:12'),(75,1,'Bluetooth Speaker  HS-016','Bluetooth Speaker  HS-016',1,NULL,'2020-01-29 23:36:27','2020-01-29 23:36:27'),(76,1,'Bluetooth Speaker','Bluetooth Speaker',1,NULL,'2020-01-29 23:51:33','2020-01-29 23:51:33'),(77,1,'Bluetooth Speaker u-2500bt image','Bluetooth Speaker u-2500bt image',1,NULL,'2020-01-29 23:58:44','2020-01-29 23:58:44'),(78,1,'Bluetooth Speaker x7reem2 mini','Bluetooth Speaker x7reem2 mini',1,NULL,'2020-01-30 00:04:43','2020-01-30 00:04:43'),(79,1,'Bluetooth Speaker new Rixing  RN-2010','Bluetooth Speaker new Rixing  RN-2010',1,NULL,'2020-01-30 00:07:28','2020-01-30 00:07:28'),(80,1,'Bluetooth Speaker s815','Bluetooth Speaker s815',1,NULL,'2020-01-30 00:10:56','2020-01-30 00:10:56'),(81,1,'Bluetooth Speaker KTX-1057','Bluetooth Speaker KTX-1057',1,NULL,'2020-01-30 00:13:34','2020-01-30 00:13:34'),(82,1,'Bluetooth Speaker was- 842','Bluetooth Speaker was- 842',1,NULL,'2020-01-30 00:16:02','2020-01-30 00:16:02'),(83,1,'Bluetooth Speaker was- 837','Bluetooth Speaker was- 837',1,NULL,'2020-01-30 00:17:18','2020-01-30 00:17:18'),(84,1,'Bluetooth Speaker K5','Bluetooth Speaker K5',1,NULL,'2020-01-30 00:19:44','2020-01-30 00:19:44'),(85,1,'BIOS Battery','BIOS Battery',1,NULL,'2020-01-30 03:33:23','2020-01-30 03:33:23'),(86,1,'mobile screen protector(Normal)','mobile screen protector(Normal)',1,NULL,'2020-01-30 19:37:55','2020-01-30 19:37:55'),(87,1,'mobile screen protector','mobile screen protector',1,NULL,'2020-01-30 19:48:03','2020-01-30 19:48:03'),(88,1,'Laptop Servicing','Laptop Servicing',1,NULL,'2020-01-31 18:26:54','2020-01-31 18:26:54'),(89,1,'Laptop Battery','Laptop Battery Dele 4050',1,NULL,'2020-02-01 02:43:00','2020-02-01 02:43:00'),(90,1,'TV Remot','TV Remot',1,NULL,'2020-02-02 01:15:06','2020-02-02 01:15:06');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Ray Computer & Electronics',134,'2020-01-26',NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"is_pos_subtotal_editable\":\"1\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}',1,'2020-01-27 03:00:32','2020-02-01 02:47:37');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','Ray Computer & Electronics','Shop No -48, Molla Super Market, Charagali','Bangladesh','Gazipur','Tongi','1710',1,1,1,'browser',NULL,'01635009232',NULL,NULL,'http://bestsmartsecuritycamera.com','Multi-Cuisine Restaurant & Party Center',NULL,NULL,NULL,NULL,'2020-01-27 03:00:32','2020-01-27 21:57:54');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,0.00,'cash','credit','initial',NULL,'2020-01-27 05:09:09','2020-01-27 05:09:09'),(6,1,350.00,'cash','credit','sell',22,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(7,1,0.00,'cash','credit','sell',22,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(8,1,350.00,'cash','credit','sell',24,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(9,1,0.00,'cash','credit','sell',24,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(10,1,100.00,'cash','credit','sell',27,'2020-01-27 20:51:51','2020-01-27 20:51:51'),(11,1,0.00,'cash','credit','sell',27,'2020-01-27 20:51:51','2020-01-27 20:51:51'),(12,1,3200.00,'cash','credit','sell',37,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(13,1,0.00,'cash','credit','sell',37,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(14,1,1000.00,'cash','credit','sell',38,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(15,1,0.00,'cash','credit','sell',38,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(16,1,3200.00,'cash','credit','sell',78,'2020-01-28 21:36:14','2020-01-28 21:36:14'),(17,1,0.00,'cash','credit','sell',78,'2020-01-28 21:36:14','2020-01-28 21:36:14'),(18,1,700.00,'cash','credit','sell',110,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(19,1,0.00,'cash','credit','sell',110,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(20,1,450.00,'cash','credit','sell',112,'2020-01-30 03:25:15','2020-01-30 03:25:15'),(21,1,0.00,'cash','credit','sell',112,'2020-01-30 03:25:15','2020-01-30 03:25:15'),(28,1,20.00,'cash','credit','sell',130,'2020-01-31 17:38:39','2020-01-31 17:38:39'),(29,1,0.00,'cash','credit','sell',130,'2020-01-31 17:38:39','2020-01-31 17:38:39'),(30,1,100.00,'cash','credit','sell',132,'2020-01-31 17:43:10','2020-01-31 17:43:10'),(31,1,0.00,'cash','credit','sell',132,'2020-01-31 17:43:10','2020-01-31 17:43:10'),(32,1,100.00,'cash','debit','refund',132,'2020-01-31 18:08:46','2020-01-31 18:08:46'),(33,1,0.00,'cash','credit','sell',136,'2020-01-31 18:33:21','2020-01-31 18:33:21'),(34,1,0.00,'cash','credit','sell',136,'2020-01-31 18:33:21','2020-01-31 18:33:21'),(35,1,500.00,'cash','credit','sell',136,'2020-01-31 18:35:22','2020-01-31 18:35:22'),(39,1,480.00,'cash','credit','sell',149,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(40,1,0.00,'cash','credit','sell',149,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(41,1,100.00,'cash','credit','sell',151,'2020-02-02 01:18:38','2020-02-02 01:18:38'),(42,1,0.00,'cash','credit','sell',151,'2020-02-02 01:18:38','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,'open',NULL,0.00,0,0,NULL,'2020-01-27 05:09:09','2020-01-27 05:09:09');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Router',1,NULL,0,1,NULL,'2020-01-27 04:09:04','2020-01-27 04:09:04'),(2,'Laptop Power Cable',1,'100',0,1,NULL,'2020-01-27 04:09:26','2020-01-27 04:09:26'),(3,'Remax',1,'101',0,1,NULL,'2020-01-27 04:09:46','2020-01-27 04:09:46'),(4,'Colling Fan',1,'203',0,1,NULL,'2020-01-27 04:21:04','2020-01-27 04:21:04'),(5,'Processor',1,'204',0,1,NULL,'2020-01-27 04:21:25','2020-01-27 04:21:25'),(6,'Mouse',1,'206',0,1,NULL,'2020-01-27 04:37:16','2020-01-27 04:37:16'),(7,'Keyboard',1,'207',0,1,NULL,'2020-01-27 04:37:30','2020-01-27 04:37:30'),(8,'Head Phone',1,'208',0,1,NULL,'2020-01-27 04:37:47','2020-01-27 04:37:47'),(9,'Mobile Charger',1,'209',0,1,NULL,'2020-01-27 04:38:03','2020-01-27 04:38:03'),(10,'Hard Disk',1,'210',0,1,NULL,'2020-01-27 04:38:24','2020-01-27 04:38:24'),(11,'Mother Board',1,'Mother Board',0,1,NULL,'2020-01-27 04:38:34','2020-01-27 20:51:30'),(12,'Ram',1,'211',0,1,NULL,'2020-01-27 04:38:43','2020-01-27 04:38:43'),(13,'Speaker',1,'212',0,1,'2020-01-29 23:35:09','2020-01-27 04:39:25','2020-01-29 23:35:09'),(14,'Camera',1,'213',0,1,NULL,'2020-01-27 04:40:08','2020-01-27 04:40:08'),(15,'Mobile Stand',1,'214',0,1,NULL,'2020-01-27 04:40:35','2020-01-27 04:40:35'),(16,'VGA Cable',1,'VGA Cable',0,1,NULL,'2020-01-27 20:44:30','2020-01-27 20:44:30'),(17,'Power Cable',1,'Power Cable',0,1,NULL,'2020-01-27 20:48:49','2020-01-27 20:48:49'),(18,'Land Card',1,'500',0,1,NULL,'2020-01-27 22:54:33','2020-01-27 22:54:33'),(19,'Mobile Charger Adopter',1,'Mobile Charger Adopter',0,1,NULL,'2020-01-27 23:04:53','2020-01-27 23:04:53'),(20,'VNC Connector',1,'700',0,1,NULL,'2020-01-27 23:08:11','2020-01-27 23:08:11'),(21,'CCTV ADOPTER',1,'900',0,1,NULL,'2020-01-27 23:10:31','2020-01-27 23:10:31'),(22,'Data Cable',1,'901',0,1,NULL,'2020-01-27 23:55:25','2020-01-27 23:55:25'),(23,'Usb Sound Card',1,'901',0,1,NULL,'2020-01-28 03:07:06','2020-01-28 03:07:06'),(24,'VR',1,'902',0,1,NULL,'2020-01-28 03:39:24','2020-01-28 03:39:24'),(25,'CCTV Camera',1,'902',0,1,NULL,'2020-01-29 21:16:44','2020-01-29 21:16:44'),(26,'Joystick',1,'904',0,1,NULL,'2020-01-29 21:21:01','2020-01-29 21:21:01'),(27,'Bluetooth headphone',1,'905',0,1,NULL,'2020-01-29 21:25:52','2020-01-29 22:53:59'),(28,'Secondary HDD Caddy',1,'906',0,1,NULL,'2020-01-29 21:38:31','2020-01-29 21:38:31'),(29,'Wireless Mouse',1,'907',0,1,NULL,'2020-01-29 22:13:06','2020-01-29 22:13:06'),(30,'Mobile Battery',1,'908',0,1,NULL,'2020-01-29 22:21:43','2020-01-29 22:21:43'),(31,'OTG',1,'909',0,1,NULL,'2020-01-29 22:56:19','2020-01-29 22:56:19'),(32,'USB Half',1,'910',0,1,NULL,'2020-01-29 23:05:55','2020-01-29 23:05:55'),(33,'Speaker',1,'911',0,1,NULL,'2020-01-29 23:30:08','2020-01-29 23:30:08'),(34,'Bluetooth Speaker',1,'912',0,1,NULL,'2020-01-29 23:31:14','2020-01-29 23:31:14'),(35,'BIOS Battery',1,'BIOS Battery',0,1,NULL,'2020-01-30 03:34:02','2020-01-30 03:34:02'),(36,'Other',1,'914',0,1,NULL,'2020-01-30 19:34:57','2020-01-30 19:34:57'),(37,'Servicing',1,'915',0,1,NULL,'2020-01-30 19:35:36','2020-01-30 19:35:36'),(38,'Mobile Protector',1,'916',0,1,NULL,'2020-01-30 19:36:07','2020-01-30 19:36:07'),(39,'Laptop Battery',1,'917',0,1,NULL,'2020-02-01 02:41:41','2020-02-01 02:41:41'),(40,'TV Remot',1,'918',0,1,NULL,'2020-02-02 01:14:39','2020-02-02 01:14:39');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(20,2) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(2,1,'supplier','Win Trade','Jahangir',NULL,'CO0002',NULL,'Elephane Rooad',NULL,NULL,NULL,'01818877202',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:01:56','2020-01-27 20:09:19'),(3,1,'customer',NULL,'Anower',NULL,'CO0003',NULL,'Dhaka',NULL,'Bangladesh',NULL,'01672713511',NULL,NULL,NULL,'days',5000.00,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:08:44','2020-01-27 20:08:44'),(4,1,'supplier','Solyman','Solyman',NULL,'CO0004',NULL,'Elephane Rooad',NULL,'Bangladesh',NULL,'0172060566',NULL,NULL,NULL,'days',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:11:34','2020-01-27 20:11:34'),(5,1,'customer',NULL,'Shamim',NULL,'CO0005',NULL,'Hokers Market',NULL,'Bangladesh',NULL,'01795870357',NULL,NULL,NULL,'days',NULL,1,0,NULL,'6000',NULL,NULL,NULL,NULL,'2020-01-27 20:13:24','2020-01-27 20:18:39'),(6,1,'customer',NULL,'Sumon Khan',NULL,'CO0006',NULL,'Gazipur',NULL,'Bangladesh',NULL,'01911102154',NULL,NULL,NULL,'months',NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 20:09:41','2020-01-30 20:09:41'),(7,1,'customer',NULL,'Gabindo (Deep)',NULL,'CO0007',NULL,'Gazipur','Dhaka','Bangladesh',NULL,'017937261168',NULL,NULL,NULL,NULL,NULL,1,0,NULL,'Dattapura,tongi, Gazipur',NULL,NULL,NULL,NULL,'2020-01-31 18:06:16','2020-01-31 18:07:12'),(8,1,'both','Milon Maker','Milon Milon Maker',NULL,'CO0008',NULL,'Gazipur','Dhaka','Bangladesh',NULL,'01967435340',NULL,NULL,NULL,NULL,NULL,1,0,NULL,'Apuspara,tongi, Gazipur',NULL,NULL,NULL,NULL,'2020-01-31 18:20:35','2020-01-31 18:20:35'),(9,1,'customer',NULL,'Nadim',NULL,'CO0009',NULL,'Gazipur','Dhaka','Bangladesh',NULL,'01913883277',NULL,NULL,NULL,NULL,NULL,1,0,NULL,'Dattapura,tongi, Gazipur',NULL,NULL,NULL,NULL,'2020-02-01 01:45:22','2020-02-01 01:45:22'),(10,1,'supplier','JM Technology','Md. Mizanur Rahman',NULL,'CO0010',NULL,'Dhaka','Dhaka','Bangladesh',NULL,'01813546444',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 02:23:11','2020-02-01 02:23:11');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `applicable_in_spg` tinyint(1) DEFAULT '0',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'Laptop Keyboard',1,'200',NULL,'2020-01-27 04:12:18','2020-01-27 04:12:18'),(2,'Tea',1,'201',NULL,'2020-01-27 04:12:46','2020-01-27 04:12:46'),(3,'Laptop',1,'202',NULL,'2020-01-27 04:13:07','2020-01-27 04:13:07'),(4,'Shop Rent',1,'2000',NULL,'2020-01-27 05:32:45','2020-01-27 05:32:45'),(5,'Electricity Bill',1,'2001',NULL,'2020-01-27 05:33:06','2020-01-27 05:33:06'),(6,'Rang',1,NULL,NULL,'2020-01-28 03:00:55','2020-01-28 03:00:55'),(7,'Nasta',1,NULL,NULL,'2020-01-28 03:02:54','2020-01-28 03:02:54'),(8,'Other',1,'1000',NULL,'2020-01-28 04:00:16','2020-01-28 04:00:16'),(9,'Servecing',1,'1001',NULL,'2020-01-31 05:25:31','2020-01-31 05:25:31');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,1,1,1,0,0,0,1,NULL,1,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,1,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,'Customer','#000000',NULL,NULL,1,1,'classic',NULL,NULL,NULL,NULL,1,NULL,'[\"product_custom_field1\",\"product_custom_field2\"]',NULL,NULL,'2020-01-27 03:00:32','2020-01-30 20:28:00'),(2,'Ray Computer',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,1,'classic','Credit Note','Ref. No.','Credit Amount',NULL,1,'All Balance Due','[\"product_custom_field1\",\"product_custom_field2\"]',NULL,NULL,'2020-01-30 20:26:14','2020-01-30 20:26:14');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','',1,23,4,1,'2020-01-27 03:00:32','2020-02-02 01:18:38'),(2,1,'Sudipta','blank',NULL,0,0,4,0,'2020-01-30 20:23:39','2020-01-30 20:23:39');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2017_07_05_071953_create_currencies_table',1),(4,'2017_07_05_073658_create_business_table',1),(5,'2017_07_22_075923_add_business_id_users_table',1),(6,'2017_07_23_113209_create_brands_table',1),(7,'2017_07_26_083429_create_permission_tables',1),(8,'2017_07_26_110000_create_tax_rates_table',1),(9,'2017_07_26_122313_create_units_table',1),(10,'2017_07_27_075706_create_contacts_table',1),(11,'2017_08_04_071038_create_categories_table',1),(12,'2017_08_08_115903_create_products_table',1),(13,'2017_08_09_061616_create_variation_templates_table',1),(14,'2017_08_09_061638_create_variation_value_templates_table',1),(15,'2017_08_10_061146_create_product_variations_table',1),(16,'2017_08_10_061216_create_variations_table',1),(17,'2017_08_19_054827_create_transactions_table',1),(18,'2017_08_31_073533_create_purchase_lines_table',1),(19,'2017_10_15_064638_create_transaction_payments_table',1),(20,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(21,'2017_11_20_051930_create_table_group_sub_taxes',1),(22,'2017_11_20_063603_create_transaction_sell_lines',1),(23,'2017_11_21_064540_create_barcodes_table',1),(24,'2017_11_23_181237_create_invoice_schemes_table',1),(25,'2017_12_25_122822_create_business_locations_table',1),(26,'2017_12_25_160253_add_location_id_to_transactions_table',1),(27,'2017_12_25_163227_create_variation_location_details_table',1),(28,'2018_01_04_115627_create_sessions_table',1),(29,'2018_01_05_112817_create_invoice_layouts_table',1),(30,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(31,'2018_01_08_104124_create_expense_categories_table',1),(32,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(33,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(34,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(35,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(36,'2018_01_27_184322_create_printers_table',1),(37,'2018_01_30_181442_create_cash_registers_table',1),(38,'2018_01_31_125836_create_cash_register_transactions_table',1),(39,'2018_02_07_173326_modify_business_table',1),(40,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(41,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(42,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(43,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(44,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(45,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(46,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(47,'2018_02_13_183323_alter_decimal_fields_size',1),(48,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(49,'2018_02_15_161032_add_document_column_to_transactions_table',1),(50,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(51,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(52,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(53,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(54,'2018_02_21_105329_create_system_table',1),(55,'2018_02_23_100549_version_1_2',1),(56,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(57,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(58,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(59,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(60,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(61,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(62,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(63,'2018_03_06_210206_modify_product_barcode_types',1),(64,'2018_03_13_181541_add_expiry_type_to_business_table',1),(65,'2018_03_16_113446_product_expiry_setting_for_business',1),(66,'2018_03_19_113601_add_business_settings_options',1),(67,'2018_03_26_125334_add_pos_settings_to_business_table',1),(68,'2018_03_26_165350_create_customer_groups_table',1),(69,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(70,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(71,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(72,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(73,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(74,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(75,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(76,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(77,'2018_04_17_123122_add_lot_number_to_business',1),(78,'2018_04_17_160845_add_product_racks_table',1),(79,'2018_04_20_182015_create_res_tables_table',1),(80,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(81,'2018_04_24_114149_add_enabled_modules_business_table',1),(82,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(83,'2018_04_27_132653_quotation_related_change',1),(84,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(85,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(86,'2018_05_14_114027_add_rows_positions_for_products',1),(87,'2018_05_14_125223_add_weight_to_products_table',1),(88,'2018_05_14_164754_add_opening_stock_permission',1),(89,'2018_05_15_134729_add_design_to_invoice_layouts',1),(90,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(91,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(92,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(93,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(94,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(95,'2018_05_22_123527_create_reference_counts_table',1),(96,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(97,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(98,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(99,'2018_05_25_180603_create_modifiers_related_table',1),(100,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(101,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(102,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(103,'2018_06_05_111905_modify_products_table_for_modifiers',1),(104,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(105,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(106,'2018_06_07_182258_add_image_field_to_products_table',1),(107,'2018_06_13_133705_create_bookings_table',1),(108,'2018_06_15_173636_add_email_column_to_contacts_table',1),(109,'2018_06_27_182835_add_superadmin_related_fields_business',1),(110,'2018_07_10_101913_add_custom_fields_to_products_table',1),(111,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(112,'2018_07_17_120612_change_all_quantity_field_type_to_decimal',1),(113,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(114,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(115,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(116,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(117,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(118,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(119,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(120,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(121,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(122,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(123,'2018_09_04_155900_create_accounts_table',1),(124,'2018_09_06_114438_create_selling_price_groups_table',1),(125,'2018_09_06_154057_create_variation_group_prices_table',1),(126,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(127,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(128,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(129,'2018_09_10_152703_create_account_transactions_table',1),(130,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(131,'2018_09_19_123914_create_notification_templates_table',1),(132,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(133,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(134,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(135,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(136,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(137,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(138,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(139,'2018_10_03_185947_add_default_notification_templates_to_database',1),(140,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(141,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(142,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(143,'2018_10_22_134428_modify_variable_product_data',1),(144,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(145,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(146,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(147,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(148,'2018_10_31_175627_add_user_contact_access',1),(149,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(150,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(151,'2018_11_08_105621_add_role_permissions',1),(152,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(153,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(154,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(155,'2018_11_29_115918_add_primary_key_in_system_table',1),(156,'2018_12_03_185546_add_product_description_column_to_products_table',1),(157,'2018_12_06_114937_modify_system_table_and_users_table',1),(158,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(159,'2018_12_14_103307_modify_system_table',1),(160,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(161,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(162,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(163,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(164,'2018_12_24_154933_create_notifications_table',1),(165,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(166,'2019_01_10_124645_add_account_permission',1),(167,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(168,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(169,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(170,'2019_02_19_103118_create_discounts_table',1),(171,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(172,'2019_02_21_134324_add_permission_for_discount',1),(173,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(174,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(175,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(176,'2019_03_12_120336_create_activity_log_table',1),(177,'2019_03_15_132925_create_media_table',1),(178,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(179,'2019_05_10_132311_add_missing_column_indexing',1),(180,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(181,'2019_05_25_104922_add_view_purchase_price_permission',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(1,2,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` int(10) unsigned NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_id_notifiable_type_index` (`notifiable_id`,`notifiable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2020-01-27 02:56:53',NULL),(2,'direct_sell.access','web','2020-01-27 02:56:53',NULL),(3,'product.opening_stock','web','2020-01-27 02:56:54','2020-01-27 02:56:54'),(4,'crud_all_bookings','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(5,'crud_own_bookings','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(6,'access_default_selling_price','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(7,'purchase.payments','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(8,'sell.payments','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(9,'edit_product_price_from_sale_screen','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(10,'edit_product_discount_from_sale_screen','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(11,'roles.view','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(12,'roles.create','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(13,'roles.update','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(14,'roles.delete','web','2020-01-27 02:56:55','2020-01-27 02:56:55'),(15,'account.access','web','2020-01-27 02:56:56','2020-01-27 02:56:56'),(16,'discount.access','web','2020-01-27 02:56:56','2020-01-27 02:56:56'),(17,'view_purchase_price','web','2020-01-27 02:56:56','2020-01-27 02:56:56'),(18,'user.view','web','2020-01-27 02:56:56',NULL),(19,'user.create','web','2020-01-27 02:56:56',NULL),(20,'user.update','web','2020-01-27 02:56:56',NULL),(21,'user.delete','web','2020-01-27 02:56:56',NULL),(22,'supplier.view','web','2020-01-27 02:56:56',NULL),(23,'supplier.create','web','2020-01-27 02:56:56',NULL),(24,'supplier.update','web','2020-01-27 02:56:56',NULL),(25,'supplier.delete','web','2020-01-27 02:56:56',NULL),(26,'customer.view','web','2020-01-27 02:56:56',NULL),(27,'customer.create','web','2020-01-27 02:56:56',NULL),(28,'customer.update','web','2020-01-27 02:56:56',NULL),(29,'customer.delete','web','2020-01-27 02:56:56',NULL),(30,'product.view','web','2020-01-27 02:56:56',NULL),(31,'product.create','web','2020-01-27 02:56:56',NULL),(32,'product.update','web','2020-01-27 02:56:56',NULL),(33,'product.delete','web','2020-01-27 02:56:56',NULL),(34,'purchase.view','web','2020-01-27 02:56:56',NULL),(35,'purchase.create','web','2020-01-27 02:56:56',NULL),(36,'purchase.update','web','2020-01-27 02:56:56',NULL),(37,'purchase.delete','web','2020-01-27 02:56:56',NULL),(38,'sell.view','web','2020-01-27 02:56:56',NULL),(39,'sell.create','web','2020-01-27 02:56:56',NULL),(40,'sell.update','web','2020-01-27 02:56:56',NULL),(41,'sell.delete','web','2020-01-27 02:56:56',NULL),(42,'purchase_n_sell_report.view','web','2020-01-27 02:56:56',NULL),(43,'contacts_report.view','web','2020-01-27 02:56:56',NULL),(44,'stock_report.view','web','2020-01-27 02:56:56',NULL),(45,'tax_report.view','web','2020-01-27 02:56:56',NULL),(46,'trending_product_report.view','web','2020-01-27 02:56:56',NULL),(47,'register_report.view','web','2020-01-27 02:56:56',NULL),(48,'sales_representative.view','web','2020-01-27 02:56:56',NULL),(49,'expense_report.view','web','2020-01-27 02:56:56',NULL),(50,'business_settings.access','web','2020-01-27 02:56:56',NULL),(51,'barcode_settings.access','web','2020-01-27 02:56:56',NULL),(52,'invoice_settings.access','web','2020-01-27 02:56:56',NULL),(53,'brand.view','web','2020-01-27 02:56:56',NULL),(54,'brand.create','web','2020-01-27 02:56:56',NULL),(55,'brand.update','web','2020-01-27 02:56:56',NULL),(56,'brand.delete','web','2020-01-27 02:56:56',NULL),(57,'tax_rate.view','web','2020-01-27 02:56:56',NULL),(58,'tax_rate.create','web','2020-01-27 02:56:56',NULL),(59,'tax_rate.update','web','2020-01-27 02:56:56',NULL),(60,'tax_rate.delete','web','2020-01-27 02:56:56',NULL),(61,'unit.view','web','2020-01-27 02:56:56',NULL),(62,'unit.create','web','2020-01-27 02:56:56',NULL),(63,'unit.update','web','2020-01-27 02:56:56',NULL),(64,'unit.delete','web','2020-01-27 02:56:56',NULL),(65,'category.view','web','2020-01-27 02:56:56',NULL),(66,'category.create','web','2020-01-27 02:56:56',NULL),(67,'category.update','web','2020-01-27 02:56:56',NULL),(68,'category.delete','web','2020-01-27 02:56:56',NULL),(69,'expense.access','web','2020-01-27 02:56:56',NULL),(70,'access_all_locations','web','2020-01-27 02:56:56',NULL),(71,'dashboard.data','web','2020-01-27 02:56:56',NULL),(72,'location.1','web','2020-01-27 03:00:32','2020-01-27 03:00:32');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2020-01-27 03:57:52','2020-01-27 03:57:52'),(2,NULL,'DUMMY',2,1,'2020-01-27 04:06:06','2020-01-27 04:06:06'),(3,NULL,'DUMMY',3,1,'2020-01-27 04:25:28','2020-01-27 04:25:28'),(4,NULL,'DUMMY',4,1,'2020-01-27 04:28:05','2020-01-27 04:28:05'),(5,NULL,'DUMMY',5,1,'2020-01-27 04:30:43','2020-01-27 04:30:43'),(6,NULL,'DUMMY',6,1,'2020-01-27 20:47:00','2020-01-27 20:47:00'),(7,NULL,'DUMMY',7,1,'2020-01-27 20:50:02','2020-01-27 20:50:02'),(8,NULL,'DUMMY',8,1,'2020-01-27 20:53:20','2020-01-27 20:53:20'),(9,NULL,'DUMMY',9,1,'2020-01-27 20:55:20','2020-01-27 20:55:20'),(10,NULL,'DUMMY',10,1,'2020-01-27 20:58:26','2020-01-27 20:58:26'),(11,NULL,'DUMMY',11,1,'2020-01-27 21:00:42','2020-01-27 21:00:42'),(12,NULL,'DUMMY',12,1,'2020-01-27 21:02:43','2020-01-27 21:02:43'),(13,NULL,'DUMMY',13,1,'2020-01-27 21:04:20','2020-01-27 21:04:20'),(14,NULL,'DUMMY',14,1,'2020-01-27 21:06:03','2020-01-27 21:06:03'),(15,NULL,'DUMMY',15,1,'2020-01-27 21:07:39','2020-01-27 21:07:39'),(16,NULL,'DUMMY',16,1,'2020-01-27 21:09:54','2020-01-27 21:09:54'),(17,NULL,'DUMMY',17,1,'2020-01-27 21:12:20','2020-01-27 21:12:20'),(18,NULL,'DUMMY',18,1,'2020-01-27 22:34:40','2020-01-27 22:34:40'),(19,NULL,'DUMMY',19,1,'2020-01-27 22:38:29','2020-01-27 22:38:29'),(20,NULL,'DUMMY',20,1,'2020-01-27 22:42:57','2020-01-27 22:42:57'),(21,NULL,'DUMMY',21,1,'2020-01-27 22:48:36','2020-01-27 22:48:36'),(22,NULL,'DUMMY',22,1,'2020-01-27 22:52:54','2020-01-27 22:52:54'),(23,NULL,'DUMMY',23,1,'2020-01-27 22:57:35','2020-01-27 22:57:35'),(24,NULL,'DUMMY',24,1,'2020-01-27 22:59:35','2020-01-27 22:59:35'),(25,NULL,'DUMMY',25,1,'2020-01-27 23:03:19','2020-01-27 23:03:19'),(26,NULL,'DUMMY',26,1,'2020-01-27 23:06:35','2020-01-27 23:06:35'),(27,NULL,'DUMMY',27,1,'2020-01-27 23:09:00','2020-01-27 23:09:00'),(28,NULL,'DUMMY',28,1,'2020-01-27 23:11:56','2020-01-27 23:11:56'),(29,NULL,'DUMMY',29,1,'2020-01-27 23:15:39','2020-01-27 23:15:39'),(30,NULL,'DUMMY',30,1,'2020-01-27 23:18:55','2020-01-27 23:18:55'),(31,NULL,'DUMMY',31,1,'2020-01-27 23:21:28','2020-01-27 23:21:28'),(32,NULL,'DUMMY',32,1,'2020-01-27 23:25:11','2020-01-27 23:25:11'),(33,NULL,'DUMMY',33,1,'2020-01-27 23:27:48','2020-01-27 23:27:48'),(34,NULL,'DUMMY',34,1,'2020-01-27 23:33:32','2020-01-27 23:33:32'),(35,NULL,'DUMMY',35,1,'2020-01-27 23:36:12','2020-01-27 23:36:12'),(36,NULL,'DUMMY',36,1,'2020-01-27 23:38:48','2020-01-27 23:38:48'),(37,NULL,'DUMMY',37,1,'2020-01-27 23:41:30','2020-01-27 23:41:30'),(38,NULL,'DUMMY',38,1,'2020-01-27 23:53:29','2020-01-27 23:53:29'),(39,NULL,'DUMMY',39,1,'2020-01-27 23:56:52','2020-01-27 23:56:52'),(40,NULL,'DUMMY',40,1,'2020-01-28 03:09:04','2020-01-28 03:09:04'),(41,NULL,'DUMMY',41,1,'2020-01-28 03:12:37','2020-01-28 03:12:37'),(42,NULL,'DUMMY',42,1,'2020-01-28 03:16:24','2020-01-28 03:16:24'),(43,NULL,'DUMMY',43,1,'2020-01-28 03:18:25','2020-01-28 03:18:25'),(44,NULL,'DUMMY',44,1,'2020-01-28 03:21:52','2020-01-28 03:21:52'),(45,NULL,'DUMMY',45,1,'2020-01-28 03:24:22','2020-01-28 03:24:22'),(46,NULL,'DUMMY',46,1,'2020-01-28 03:28:44','2020-01-28 03:28:44'),(47,NULL,'DUMMY',47,1,'2020-01-28 03:31:21','2020-01-28 03:31:21'),(48,NULL,'DUMMY',48,1,'2020-01-28 03:34:15','2020-01-28 03:34:15'),(49,NULL,'DUMMY',49,1,'2020-01-28 03:35:51','2020-01-28 03:35:51'),(50,NULL,'DUMMY',50,1,'2020-01-28 03:38:25','2020-01-28 03:38:25'),(51,NULL,'DUMMY',51,1,'2020-01-28 03:40:33','2020-01-28 03:40:33'),(52,NULL,'DUMMY',52,1,'2020-01-29 21:22:49','2020-01-29 21:22:49'),(53,NULL,'DUMMY',53,1,'2020-01-29 21:29:17','2020-01-29 21:29:17'),(54,NULL,'DUMMY',54,1,'2020-01-29 21:36:20','2020-01-29 21:36:20'),(55,NULL,'DUMMY',55,1,'2020-01-29 21:39:35','2020-01-29 21:39:35'),(56,NULL,'DUMMY',56,1,'2020-01-29 21:51:41','2020-01-29 21:51:41'),(57,NULL,'DUMMY',57,1,'2020-01-29 21:57:32','2020-01-29 21:57:32'),(58,NULL,'DUMMY',58,1,'2020-01-29 22:17:18','2020-01-29 22:17:18'),(59,NULL,'DUMMY',59,1,'2020-01-29 22:20:11','2020-01-29 22:20:11'),(60,NULL,'DUMMY',60,1,'2020-01-29 22:25:15','2020-01-29 22:25:15'),(61,NULL,'DUMMY',61,1,'2020-01-29 22:44:33','2020-01-29 22:44:33'),(62,NULL,'DUMMY',62,1,'2020-01-29 22:48:03','2020-01-29 22:48:03'),(63,NULL,'DUMMY',63,1,'2020-01-29 22:50:01','2020-01-29 22:50:01'),(64,NULL,'DUMMY',64,1,'2020-01-29 22:54:34','2020-01-29 22:54:34'),(65,NULL,'DUMMY',65,1,'2020-01-29 22:57:57','2020-01-29 22:57:57'),(66,NULL,'DUMMY',66,1,'2020-01-29 23:00:19','2020-01-29 23:00:19'),(67,NULL,'DUMMY',67,1,'2020-01-29 23:08:08','2020-01-29 23:08:08'),(68,NULL,'DUMMY',68,1,'2020-01-29 23:10:26','2020-01-29 23:10:26'),(69,NULL,'DUMMY',69,1,'2020-01-29 23:15:04','2020-01-29 23:15:04'),(70,NULL,'DUMMY',70,1,'2020-01-29 23:16:34','2020-01-29 23:16:34'),(71,NULL,'DUMMY',71,1,'2020-01-29 23:34:09','2020-01-29 23:34:09'),(72,NULL,'DUMMY',72,1,'2020-01-29 23:37:08','2020-01-29 23:37:08'),(73,NULL,'DUMMY',73,1,'2020-01-29 23:52:25','2020-01-29 23:52:25'),(74,NULL,'DUMMY',74,1,'2020-01-30 00:00:57','2020-01-30 00:00:57'),(75,NULL,'DUMMY',75,1,'2020-01-30 00:05:18','2020-01-30 00:05:18'),(76,NULL,'DUMMY',76,1,'2020-01-30 00:08:19','2020-01-30 00:08:19'),(77,NULL,'DUMMY',77,1,'2020-01-30 00:11:34','2020-01-30 00:11:34'),(78,NULL,'DUMMY',78,1,'2020-01-30 00:14:29','2020-01-30 00:14:29'),(79,NULL,'DUMMY',79,1,'2020-01-30 00:16:24','2020-01-30 00:16:24'),(80,NULL,'DUMMY',80,1,'2020-01-30 00:17:53','2020-01-30 00:17:53'),(81,NULL,'DUMMY',81,1,'2020-01-30 00:20:15','2020-01-30 00:20:15'),(82,NULL,'DUMMY',82,1,'2020-01-30 03:23:29','2020-01-30 03:23:29'),(83,NULL,'DUMMY',83,1,'2020-01-30 03:25:08','2020-01-30 03:25:08'),(85,NULL,'DUMMY',85,1,'2020-01-30 03:34:58','2020-01-30 03:34:58'),(86,NULL,'DUMMY',86,1,'2020-01-30 19:44:34','2020-01-30 19:44:34'),(87,NULL,'DUMMY',87,1,'2020-01-30 20:03:32','2020-01-30 20:03:32'),(88,NULL,'DUMMY',88,1,'2020-01-31 18:27:50','2020-01-31 18:27:50'),(89,NULL,'DUMMY',89,1,'2020-02-01 02:45:52','2020-02-01 02:45:52'),(90,NULL,'DUMMY',90,1,'2020-02-02 01:16:32','2020-02-02 01:16:32');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Laptop Power Cable',1,'single',1,8,NULL,NULL,NULL,'exclusive',1,20,'P100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580057872_laptop Power Cable.jpg','<p>Laptop Power Cable</p>',1,0,'2020-01-27 03:57:52','2020-01-27 04:36:05'),(2,'Power Bank',1,'single',1,4,NULL,NULL,NULL,'exclusive',1,1,'P101','C128',NULL,NULL,1,NULL,'954851297383',NULL,NULL,NULL,'1580058366_remax 10000mah.jpg','<p>Power Bank</p>\r\n\r\n<p>Remax&nbsp; 10000mah</p>',1,0,'2020-01-27 04:06:06','2020-01-27 04:07:59'),(3,'Colling Fan',1,'single',1,7,4,NULL,NULL,'exclusive',1,2,'P202','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'1580059528_fan.jpg','<p>Colling Fan Special</p>',1,0,'2020-01-27 04:25:28','2020-01-27 04:35:13'),(4,'Processor',1,'single',1,6,5,NULL,NULL,'exclusive',1,4,'P303','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'1580059685_Processor.jpg','<p>Processor</p>\r\n\r\n<p>Core 2 Due</p>',1,0,'2020-01-27 04:28:05','2020-01-27 04:28:05'),(5,'Colling fan',1,'single',1,5,4,NULL,NULL,'exclusive',1,2,'P203','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580060017_fan.jpg',NULL,1,0,'2020-01-27 04:30:43','2020-01-27 04:33:37'),(6,'VGA Cable',1,'single',1,9,16,NULL,NULL,'exclusive',1,5,'0006','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'1580118420_vga-cable.jpg','<p>VGA Cable</p>',1,0,'2020-01-27 20:47:00','2020-01-27 20:47:00'),(7,'Power Cable',1,'single',1,10,17,NULL,NULL,'exclusive',1,5,'0007','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580118602_computer Power cable.jpg','<p>Power Cable</p>',1,0,'2020-01-27 20:50:02','2020-01-27 20:50:02'),(8,'Mother Board',1,'single',1,11,11,NULL,NULL,'exclusive',1,2,'0008','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580118800_Mother Board.jpg','<p>Mother Board 81 ASUS</p>',1,0,'2020-01-27 20:53:20','2020-01-27 20:53:20'),(9,'Processor',1,'single',1,6,5,NULL,NULL,'exclusive',1,2,'0009','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580118920_Processor core i3 4 gen.jpg','<p>Processor core i3 4 gen</p>',1,0,'2020-01-27 20:55:20','2020-01-27 20:55:20'),(10,'RAM DDR 3 4 GB',1,'single',1,12,12,NULL,NULL,'exclusive',1,4,'0010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119106_RAM DDR 3 4 GB.jpg','<p>RAM DDR 3 4 GB</p>',1,0,'2020-01-27 20:58:26','2020-01-27 20:58:26'),(11,'RAM DDR 3 8 GB',1,'single',1,13,12,NULL,NULL,'exclusive',1,1,'0011','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119242_RAM DDR 3 8 GB.jpg','<p>RAM DDR 3 8 GB</p>',1,0,'2020-01-27 21:00:42','2020-01-27 21:00:42'),(12,'SSD 120 GB',1,'single',1,14,10,NULL,NULL,'exclusive',1,2,'0012','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119363_SSD 120 GB WD.jpg','<p>SSD 120 GB WD</p>',1,0,'2020-01-27 21:02:43','2020-01-27 21:02:43'),(13,'HDD 500 GB',1,'single',1,15,10,NULL,NULL,'exclusive',1,2,'0013','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119460_HDD 500 GB.jpg','<p>HDD 500 GB</p>',1,0,'2020-01-27 21:04:20','2020-01-27 21:04:20'),(14,'HDD 320 GB',1,'single',1,16,10,NULL,NULL,'exclusive',1,2,'0014','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119563_HDD 320 GB.jpg','<p>HDD 320 GB</p>',1,0,'2020-01-27 21:06:03','2020-01-27 21:06:03'),(15,'HDD 250 GB',1,'single',1,17,10,NULL,NULL,'exclusive',1,2,'0015','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119659_HDD 250 GB.jpg','<p>HDD 250 GB</p>',1,0,'2020-01-27 21:07:39','2020-01-27 21:07:39'),(16,'Mobile Charger',1,'single',1,18,9,NULL,NULL,'exclusive',1,5,'0016','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119794_Mobile Charger (Active).jpg','<p>Mobile Charger (Active)</p>',1,0,'2020-01-27 21:09:54','2020-01-27 21:09:54'),(17,'Mobile Charger (Excel)',1,'single',1,19,9,NULL,NULL,'exclusive',1,5,'0017','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580119940_Mobile Charger (Active).jpg','<p>Mobile Charger (Excel)</p>',1,0,'2020-01-27 21:12:20','2020-01-27 21:12:20'),(18,'Mobile Stand',1,'single',1,20,15,NULL,NULL,'exclusive',1,10,'0018','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580124880_Mobile Stand.jpeg','<p>Mobile Stand</p>',1,0,'2020-01-27 22:34:40','2020-01-27 22:34:40'),(19,'Router TP Link WR841',1,'single',1,21,1,NULL,NULL,'exclusive',1,1,'0019','C128',NULL,NULL,1,NULL,'2198234010714','365',NULL,NULL,'1580125109_Router TP Link WR841.jpg','<p>Router TP Link WR841</p>',1,0,'2020-01-27 22:38:29','2020-01-27 22:44:24'),(20,'Router TP Link WR840',1,'single',1,22,1,NULL,NULL,'exclusive',1,1,'0020','C128',NULL,NULL,1,NULL,'2195775012123','365',NULL,NULL,'1580125377_Router TP Link WR840.jpg','<p>Router TP Link WR840</p>',1,0,'2020-01-27 22:42:57','2020-01-27 22:42:57'),(21,'Router Mercusys MW301R',1,'single',1,23,1,NULL,NULL,'exclusive',1,1,'0021','C128',NULL,NULL,1,NULL,'218CB71007181','365',NULL,NULL,'1580125716_router mercusys MW301R.jpg','<p>Router Mercusys MW301R</p>',1,0,'2020-01-27 22:48:36','2020-01-27 22:48:36'),(22,'Router Tenda F3',1,'single',1,24,1,NULL,NULL,'exclusive',1,1,'0022','C128',NULL,NULL,1,NULL,'E6333012926001396','365',NULL,NULL,'1580125974_Router Tenda F3.jpg','<p>Router Tenda F3&nbsp;</p>',1,0,'2020-01-27 22:52:54','2020-01-27 22:52:54'),(23,'Land Card',1,'single',1,25,18,NULL,NULL,'exclusive',1,2,'0023','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,'1580126255_Land Card.jpg','<p>Land Card</p>',1,0,'2020-01-27 22:57:35','2020-01-27 22:57:35'),(24,'Usb Land Card',1,'single',1,26,18,NULL,NULL,'exclusive',1,2,'0024','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580126375_USB Land Card.jpg','<p>Usb Land Card</p>',1,0,'2020-01-27 22:59:35','2020-01-27 22:59:35'),(25,'land card totolink',1,'single',1,27,18,NULL,NULL,'exclusive',1,1,'0025','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580126599_TOTOLINK-PX1000-Gigabit-PCIE-LAN-Card.webp','<p>land card totolink</p>',1,0,'2020-01-27 23:03:19','2020-01-27 23:03:19'),(26,'Mobile Charger Adopter',1,'single',1,28,19,NULL,NULL,'exclusive',1,3,'0026','C128',NULL,NULL,0,NULL,NULL,'365',NULL,NULL,'1580126795_Samsung Mobile Charger Adopter.jpg','<p><strong>Samsung Mobile Charger Adopter</strong></p>',1,0,'2020-01-27 23:06:35','2020-01-27 23:06:35'),(27,'VNC Connector',1,'single',1,29,20,NULL,NULL,'exclusive',1,15,'0027','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580126940_VNC Connector.jpg','<p>VNC Connector</p>',1,0,'2020-01-27 23:09:00','2020-01-27 23:09:00'),(28,'CCTV ADOPTER',1,'single',1,30,21,NULL,NULL,'exclusive',1,3,'0028','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580127116_CCTV ADOPTER.webp','<p>CCTV ADOPTER</p>',1,0,'2020-01-27 23:11:56','2020-01-27 23:11:56'),(29,'Valuetop CCTV ADOPTER',1,'single',1,32,21,NULL,NULL,'exclusive',1,2,'0029','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580127339_Valuetop CCTV ADOPTER.jpg','<p>Valuetop CCTV ADOPTER</p>',1,0,'2020-01-27 23:15:39','2020-01-27 23:15:39'),(30,'Keyboard fast key',1,'single',1,33,7,NULL,NULL,'exclusive',1,4,'0030','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580127535_Keyboard fast key.webp','<p>Keyboard fast key</p>',1,0,'2020-01-27 23:18:55','2020-01-27 23:18:55'),(31,'Keyboard Suntech',1,'single',1,34,7,NULL,NULL,'exclusive',1,2,'0031','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580127688_Keyboard Suntech.jpg','<p>Keyboard Suntech</p>',1,0,'2020-01-27 23:21:28','2020-01-27 23:21:28'),(32,'Keyboard A4tech',1,'single',1,35,7,NULL,NULL,'exclusive',1,1,'0032','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580127911_Keyboard A4tech.jpg','<p>Keyboard A4tech</p>',1,0,'2020-01-27 23:25:11','2020-01-27 23:25:11'),(33,'keyboard logitech usb k120',1,'single',1,36,7,NULL,NULL,'exclusive',1,1,'0033','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580128068_keyboard logitech usb k120.jpg','<p>keyboard logitech usb k120</p>',1,0,'2020-01-27 23:27:48','2020-01-27 23:27:48'),(34,'USB Speaker D9',1,'single',1,37,13,NULL,NULL,'exclusive',1,3,'0034','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580128412_USB Speaker D9.jpg','<p>USB Speaker D9</p>',1,0,'2020-01-27 23:33:32','2020-01-27 23:33:32'),(35,'USB Speaker D7',1,'single',1,38,13,NULL,NULL,'exclusive',1,8,'0035','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580128572_USB Speaker D7.webp','<p>USB Speaker D7</p>',1,0,'2020-01-27 23:36:12','2020-01-27 23:36:12'),(36,'USB Speaker D10',1,'single',1,39,13,NULL,NULL,'exclusive',1,3,'0036','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580128728_USB Speaker D10.jpg','<p>USB Speaker D10</p>',1,0,'2020-01-27 23:38:48','2020-01-27 23:38:48'),(37,'ezviz camera',1,'single',1,40,14,NULL,NULL,'exclusive',1,1,'0037','C128',NULL,NULL,1,'256g','D50249995','365',NULL,NULL,'1580128890_Ezvis.jpg','<p>ezviz camera</p>',1,0,'2020-01-27 23:41:30','2020-01-27 23:43:50'),(38,'active charger u143k',1,'single',1,41,9,NULL,NULL,'exclusive',1,1,'0038','C128',NULL,NULL,1,NULL,NULL,'180',NULL,NULL,'1580129609_Mobile Charger Active.jpg','<p>active charger u143k</p>',1,0,'2020-01-27 23:53:29','2020-01-27 23:53:29'),(39,'Data Cable',1,'single',1,42,NULL,NULL,NULL,'exclusive',1,5,'0039','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580129812_Data Cable.jpg','<p>Data Cable</p>',1,0,'2020-01-27 23:56:52','2020-01-27 23:56:52'),(40,'Usb Sound Card',1,'single',1,43,23,NULL,NULL,'exclusive',1,4,'0040','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580141344_Usb Sound Card.webp','<p>Usb Sound Card</p>',1,0,'2020-01-28 03:09:04','2020-01-28 03:09:04'),(41,'Mouse Astrum',1,'single',1,44,6,NULL,NULL,'exclusive',1,4,'0041','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580141557_Mouse Astrum.jpg','<p>Mouse Astrum</p>',1,0,'2020-01-28 03:12:37','2020-01-28 03:12:37'),(42,'Mouse Havit',1,'single',1,45,NULL,NULL,NULL,'exclusive',1,7,'0042','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580141784_Mouse Havit.jpg','<p>Mouse Havit</p>',1,0,'2020-01-28 03:16:24','2020-01-28 03:16:24'),(43,'Mouse Fastkey',1,'single',1,46,6,NULL,NULL,'exclusive',1,8,'0043','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580141905_Mouse Fastkey.webp','<p>Mouse Fastkey</p>',1,0,'2020-01-28 03:18:25','2020-01-28 03:18:25'),(44,'Mouse Micropack',1,'single',1,47,6,NULL,NULL,'exclusive',1,1,'0044','C128',NULL,NULL,1,NULL,'129190109533','365',NULL,NULL,'1580142112_Mouse Micropack.jpg','<p>Mouse Micropack</p>',1,0,'2020-01-28 03:21:52','2020-01-28 03:21:52'),(45,'Mouse Delux',1,'single',1,48,6,NULL,NULL,'exclusive',1,1,'0045','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580142262_Mouse Delux.jpg','<p>Mouse Delux M321</p>',1,0,'2020-01-28 03:24:22','2020-01-28 03:25:14'),(46,'Mouse Delux M107 Wireless',1,'single',1,49,6,NULL,NULL,'exclusive',1,1,'0046','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580142524_Mouse Delux M107 Wireless.jpg','<p>Mouse Delux M107 Wireless</p>',1,0,'2020-01-28 03:28:44','2020-01-28 03:28:44'),(47,'Mouse Gaming',1,'single',1,50,6,NULL,NULL,'exclusive',1,2,'0047','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580142681_Mouse Gaming.png','<p>Mouse Gaming</p>',1,0,'2020-01-28 03:31:21','2020-01-28 03:31:21'),(48,'Mouse Zornwee',1,'single',1,51,6,NULL,NULL,'exclusive',1,2,'0048','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580142855_Mouse Zornwee.jpg','<p>Mouse Zornwee</p>',1,0,'2020-01-28 03:34:15','2020-01-28 03:34:15'),(49,'Mouse Havit Gaming',1,'single',1,52,NULL,NULL,NULL,'exclusive',1,1,'0049','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580142951_Mouse Havit Gaming.jpg','<p>Mouse Havit Gaming</p>',1,0,'2020-01-28 03:35:51','2020-01-28 03:35:51'),(50,'Mouse W4 Wireless',1,'single',1,53,6,NULL,NULL,'exclusive',1,1,'0050','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580143105_Mouse W4 Wireless.jpg','<p>Mouse W4 Wireless W529</p>',1,0,'2020-01-28 03:38:25','2020-01-28 03:38:25'),(51,'vr box',1,'single',1,54,24,NULL,NULL,'exclusive',1,1,'0051','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580143233_vr box.jpg','<p>vr box</p>',1,0,'2020-01-28 03:40:33','2020-01-28 03:40:33'),(52,'joystick',1,'single',1,55,26,NULL,NULL,'exclusive',1,1,'0052','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580293369_joystick.jpg','<p>joystick</p>',1,0,'2020-01-29 21:22:49','2020-01-29 21:22:49'),(53,'Bluetooth headset',1,'single',1,56,27,NULL,NULL,'exclusive',1,2,'0053','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580293757_bluetooth headset.jpg','<p>bluetooth headset</p>',1,0,'2020-01-29 21:29:17','2020-01-29 21:29:17'),(54,'Mobile Charger',1,'single',1,57,9,NULL,NULL,'exclusive',1,4,'0054','C128',NULL,NULL,0,NULL,NULL,'6M',NULL,NULL,'1580294180_Excel Charger.jpg','<p>Excel Mobile Charger</p>',1,0,'2020-01-29 21:36:20','2020-01-29 21:36:20'),(55,'Secondary HDD Caddy',1,'single',1,58,28,NULL,NULL,'exclusive',1,3,'0055','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580294375_secondary hdd caddy.webp','<p>Secondary HDD Caddy</p>',1,0,'2020-01-29 21:39:35','2020-01-29 21:39:35'),(56,'Uiisii u7 head phone',1,'single',1,59,8,NULL,NULL,'exclusive',1,4,'0056','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580295101_UIISII-U7-9.jpg','<p>Uiisii u7 head phone</p>',1,0,'2020-01-29 21:51:41','2020-01-29 21:51:41'),(57,'Remax RM 512',1,'single',1,60,8,NULL,NULL,'exclusive',1,2,'0057','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580295452_Remax RM 512.jpg','<p>Remax RM 512</p>',1,0,'2020-01-29 21:57:32','2020-01-29 21:57:32'),(58,'Wireless Mouse',1,'single',1,61,29,NULL,NULL,'exclusive',1,3,'0058','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580296638_Wireless Mouse.jpg','<p>Wireless Mouse</p>',1,0,'2020-01-29 22:17:18','2020-01-29 22:17:18'),(59,'Remax Data Cable',1,'single',1,62,22,NULL,NULL,'exclusive',1,3,'0059','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580296811_Remax Data Cable.jpg','<p>Remax Data Cable</p>',1,0,'2020-01-29 22:20:11','2020-01-29 22:20:11'),(60,'Mobile Battery Excel',1,'single',1,63,30,NULL,NULL,'exclusive',1,2,'0060','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580297115_Mobile Battery Excel.jpg','<p>Mobile Battery Excel</p>',1,0,'2020-01-29 22:25:15','2020-01-29 22:25:15'),(61,'A4tech mouse',1,'single',1,64,6,NULL,NULL,'exclusive',1,2,'0061','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580298273_A4tech mouse.jpg','<p>A4tech mouse</p>',1,0,'2020-01-29 22:44:33','2020-01-29 22:44:33'),(62,'Asus mouse',1,'single',1,65,6,NULL,NULL,'exclusive',1,1,'0062','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580298483_Asus mouse.jpg','<p>Asus mouse</p>',1,0,'2020-01-29 22:48:03','2020-01-29 22:48:03'),(63,'Havit Wireless Mouse',1,'single',1,66,6,NULL,NULL,'exclusive',1,1,'0063','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580298601_havit wireless mouse.jpg','<p>Havit Wireless Mouse</p>',1,0,'2020-01-29 22:50:01','2020-01-29 22:50:01'),(64,'bluetooth headphones sport',1,'single',1,67,27,NULL,NULL,'exclusive',1,1,'0064','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580298874_bluetooth headphones sport.webp','<p>bluetooth headphones sport</p>',1,0,'2020-01-29 22:54:34','2020-01-29 22:54:34'),(65,'OTG Cable',1,'single',1,68,31,NULL,NULL,'exclusive',1,2,'0065','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580299077_OTG.jpg','<p>OTG Cable</p>',1,0,'2020-01-29 22:57:57','2020-01-29 22:57:57'),(66,'OTG Remax',1,'single',1,69,31,NULL,NULL,'exclusive',1,3,'0066','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580299219_OTG Remax.jpg','<p>OTG Remax Tpye C</p>',1,0,'2020-01-29 23:00:19','2020-01-29 23:00:19'),(67,'USB Half P-1703',1,'single',1,70,32,NULL,NULL,'exclusive',1,1,'0067','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580299688_USB Half p1703.jpg','<p>USB Half P-1703</p>',1,0,'2020-01-29 23:08:08','2020-01-29 23:08:08'),(68,'usb half 4port p-1601',1,'single',1,71,32,NULL,NULL,'exclusive',1,1,'0068','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580299826_usb half 4port p-1601.jpg','<p>usb half 4port p-1601</p>',1,0,'2020-01-29 23:10:26','2020-01-29 23:10:26'),(69,'usb half 4port u 3.0',1,'single',1,72,32,NULL,NULL,'exclusive',1,1,'0069','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580300104_usb half 4 3.0.jpg','<p>usb half 4port u 3.0 30cm</p>',1,0,'2020-01-29 23:15:04','2020-01-29 23:15:04'),(70,'usb half 4port u 3.0 120cm',1,'single',1,73,32,NULL,NULL,'exclusive',1,1,'0070','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580300194_usb half 4 3.0.jpg','<p>usb half 4port u 3.0 120cm</p>',1,0,'2020-01-29 23:16:34','2020-01-29 23:16:34'),(71,'Bluetooth Speaker  nbs-14',1,'single',1,74,34,NULL,NULL,'exclusive',1,2,'0071','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580301249_Bluetooth Speaker  nbs-14.webp','<p>Bluetooth Speaker &nbsp;nbs-14</p>',1,0,'2020-01-29 23:34:09','2020-01-29 23:34:09'),(72,'Bluetooth Speaker  HS-016',1,'single',1,75,34,NULL,NULL,'exclusive',1,1,'0072','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580301428_Bluetooth Speaker  HS-016.jpg','<p>Bluetooth Speaker &nbsp;HS-016</p>',1,0,'2020-01-29 23:37:08','2020-01-29 23:37:08'),(73,'Bluetooth Speaker',1,'single',1,76,34,NULL,NULL,'exclusive',1,1,'0073','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580302615_Bluetooth Speaker.jpg','<p>Bluetooth Speaker</p>',1,0,'2020-01-29 23:52:25','2020-01-29 23:56:55'),(74,'Bluetooth Speaker u-2500bt image',1,'single',1,77,34,NULL,NULL,'exclusive',1,1,'0074','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580302857_Bluetooth Speaker u-2500bt image.jpg','<p>Bluetooth Speaker u-2500bt image</p>',1,0,'2020-01-30 00:00:57','2020-01-30 00:00:57'),(75,'Bluetooth Speaker x7reem2 mini',1,'single',1,78,34,NULL,NULL,'exclusive',1,1,'0075','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303118_Bluetooth Speaker x7reem2 mini.jpg','<p>Bluetooth Speaker x7reem2 mini</p>',1,0,'2020-01-30 00:05:18','2020-01-30 00:05:18'),(76,'Bluetooth Speaker new Rixing  RN-2010',1,'single',1,79,34,NULL,NULL,'exclusive',1,1,'0076','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303299_Bluetooth Speaker new Rixing  RN-2010.jpg','<p>Bluetooth Speaker new Rixing &nbsp;RN-2010</p>',1,0,'2020-01-30 00:08:19','2020-01-30 00:08:19'),(77,'Bluetooth Speaker s815',1,'single',1,80,34,NULL,NULL,'exclusive',1,1,'0077','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303494_Bluetooth Speaker s815.webp','<p>Bluetooth Speaker s815</p>',1,0,'2020-01-30 00:11:34','2020-01-30 00:11:34'),(78,'Bluetooth Speaker KTX-1057',1,'single',1,81,34,NULL,NULL,'exclusive',1,1,'0078','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303669_Bluetooth Speaker KTX-1057.jpg','<p>Bluetooth Speaker KTX-1057</p>',1,0,'2020-01-30 00:14:29','2020-01-30 00:14:29'),(79,'Bluetooth Speaker was- 842',1,'single',1,82,34,NULL,NULL,'exclusive',1,1,'0079','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303784_Bluetooth Speaker was- 842.jpg','<p>Bluetooth Speaker was- 842</p>',1,0,'2020-01-30 00:16:24','2020-01-30 00:16:24'),(80,'Bluetooth Speaker was- 837',1,'single',1,83,34,NULL,NULL,'exclusive',1,1,'0080','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580303873_Bluetooth Speaker was- 837.jpg','<p>Bluetooth Speaker was- 837</p>',1,0,'2020-01-30 00:17:53','2020-01-30 00:17:53'),(81,'Bluetooth Speaker K5',1,'single',1,84,34,NULL,NULL,'exclusive',1,1,'0081','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580304015_Bluetooth Speaker K5.jpg','<p>Bluetooth Speaker K5</p>',1,0,'2020-01-30 00:20:15','2020-01-30 00:20:15'),(82,'Power Supply Repair',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,1,'0082','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,'2020-01-30 03:23:29','2020-01-30 03:23:29'),(83,'Speaker Repair',1,'single',1,NULL,NULL,NULL,NULL,'exclusive',1,1,'0083','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,'2020-01-30 03:25:08','2020-01-30 03:25:08'),(85,'BIOS Battery',1,'single',1,85,35,NULL,NULL,'exclusive',1,30,'0085','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580315697_BIOS Battery.jpg','<p>BIOS Battery</p>',1,0,'2020-01-30 03:34:57','2020-01-30 03:34:57'),(86,'mobile screen protector',1,'single',1,86,38,NULL,NULL,'exclusive',1,249,'0086','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580373874_mobile screen protector(Normal).jpg','<p>mobile screen protector(Normal)</p>',1,0,'2020-01-30 19:44:34','2020-01-30 19:44:34'),(87,'mobile screen protector',1,'single',1,87,38,NULL,NULL,'exclusive',1,95,'0087','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580375012_mobile screen protector.jpg','<p>mobile screen protector</p>',1,0,'2020-01-30 20:03:32','2020-01-30 20:03:32'),(88,'Servicing',1,'single',1,88,37,NULL,NULL,'exclusive',1,1,'0088','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'<p>Laptop Servicing</p>',1,0,'2020-01-31 18:27:50','2020-01-31 18:27:50'),(89,'Laptop Battery',1,'single',1,89,39,NULL,NULL,'exclusive',1,1,'0089','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580485552_Laptop Battery n 4050.jpg','<p>Laptop Battery n 4050 (JM Technology)</p>',1,0,'2020-02-01 02:45:52','2020-02-01 02:45:52'),(90,'TV Remot',1,'single',1,90,40,NULL,NULL,'exclusive',1,4,'0090','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1580566592_tv remot.jpg','<p>TV Remot</p>',1,0,'2020-02-02 01:16:32','2020-02-02 01:16:32');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `pp_without_discount` decimal(20,2) NOT NULL DEFAULT '0.00' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(20,2) DEFAULT NULL,
  `purchase_price_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(20,4) DEFAULT '0.0000',
  `quantity_adjusted` decimal(20,4) DEFAULT '0.0000',
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,3,3,3,10.0000,165.00,0.00,165.00,165.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 05:06:01','2020-01-27 20:46:42'),(2,6,5,5,2.0000,240.00,0.00,240.00,240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 05:23:09','2020-01-27 05:27:03'),(3,7,4,4,5.0000,150.00,0.00,150.00,150.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 05:23:47','2020-01-27 05:35:30'),(4,8,1,1,20.0000,35.00,0.00,35.00,35.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 05:24:07','2020-01-27 20:51:51'),(5,9,2,2,2.0000,750.00,0.00,750.00,750.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 05:24:44','2020-01-28 00:50:48'),(6,25,6,6,5.0000,90.00,0.00,90.00,90.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 20:47:16','2020-01-27 20:47:16'),(7,26,7,7,10.0000,45.00,0.00,45.00,45.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 20:50:29','2020-01-27 20:50:29'),(8,28,8,8,2.0000,2200.00,0.00,2200.00,2200.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 20:53:32','2020-01-27 21:59:32'),(9,29,9,9,2.0000,3200.00,0.00,3200.00,3200.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 20:55:42','2020-01-27 20:55:42'),(10,30,10,10,4.0000,900.00,0.00,900.00,900.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 20:58:41','2020-01-27 20:58:41'),(11,31,11,11,1.0000,1700.00,0.00,1700.00,1700.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:00:54','2020-01-27 21:00:54'),(12,32,12,12,2.0000,1300.00,0.00,1300.00,1300.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:02:59','2020-01-27 21:02:59'),(13,33,13,13,4.0000,925.00,0.00,925.00,925.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:04:39','2020-01-27 21:04:39'),(14,34,14,14,2.0000,650.00,0.00,650.00,650.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:06:19','2020-01-27 21:06:19'),(15,35,16,16,5.0000,70.00,0.00,70.00,70.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:10:07','2020-01-27 21:10:07'),(16,36,17,17,5.0000,70.00,0.00,70.00,70.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 21:12:37','2020-01-27 21:12:37'),(17,39,18,18,9.0000,20.00,0.00,20.00,20.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 22:35:00','2020-01-27 22:35:00'),(18,40,19,19,1.0000,1130.00,0.00,1130.00,1130.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 22:38:52','2020-01-27 22:38:52'),(19,41,20,20,1.0000,1150.00,0.00,1150.00,1150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 22:43:14','2020-01-27 22:43:14'),(20,42,22,22,1.0000,1000.00,0.00,1000.00,1000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 22:53:12','2020-01-27 22:53:12'),(21,43,21,21,1.0000,800.00,0.00,800.00,800.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 22:53:21','2020-01-27 22:53:21'),(22,44,24,24,2.0000,115.00,0.00,115.00,115.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:00:01','2020-01-27 23:00:01'),(23,45,23,23,2.0000,150.00,0.00,150.00,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:00:42','2020-01-27 23:00:42'),(24,46,25,25,1.0000,230.00,0.00,230.00,230.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:03:56','2020-01-27 23:03:56'),(25,47,26,26,3.0000,80.00,0.00,80.00,80.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:06:55','2020-01-27 23:06:55'),(26,48,27,27,15.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:09:34','2020-01-27 23:09:34'),(27,49,28,28,3.0000,95.00,0.00,95.00,95.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:12:13','2020-01-27 23:12:13'),(28,50,29,29,2.0000,300.00,0.00,300.00,300.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:16:15','2020-01-27 23:16:15'),(29,51,30,30,4.0000,155.00,0.00,155.00,155.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:19:14','2020-01-27 23:19:14'),(30,52,31,31,2.0000,210.00,0.00,210.00,210.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:21:48','2020-01-27 23:21:48'),(31,53,32,32,1.0000,450.00,0.00,450.00,450.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:25:41','2020-01-27 23:25:41'),(32,54,33,33,1.0000,450.00,0.00,450.00,450.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:28:18','2020-01-27 23:28:18'),(33,55,34,34,3.0000,260.00,0.00,260.00,260.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:33:54','2020-01-27 23:33:54'),(34,56,35,35,8.0000,250.00,0.00,250.00,250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:36:44','2020-01-27 23:36:44'),(35,57,36,36,3.0000,250.00,0.00,250.00,250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:39:24','2020-01-27 23:39:24'),(36,58,37,37,2.0000,2300.00,0.00,2300.00,2300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:41:45','2020-01-29 21:17:26'),(37,59,38,38,1.0000,150.00,0.00,150.00,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-27 23:53:45','2020-01-27 23:53:45'),(38,62,40,40,5.0000,140.00,0.00,140.00,140.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:09:32','2020-01-28 03:09:32'),(39,63,41,41,4.0000,180.00,0.00,180.00,180.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:13:48','2020-01-28 03:13:48'),(40,64,42,42,7.0000,110.00,0.00,110.00,110.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:16:55','2020-01-28 03:16:55'),(41,65,43,43,8.0000,55.00,0.00,55.00,55.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:18:49','2020-01-28 03:18:49'),(42,66,44,44,1.0000,195.00,0.00,195.00,195.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:22:33','2020-01-28 03:22:33'),(43,67,45,45,1.0000,170.00,0.00,170.00,170.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:24:40','2020-01-28 03:24:40'),(44,68,46,46,1.0000,450.00,0.00,450.00,450.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:29:10','2020-01-28 03:29:10'),(45,69,47,47,2.0000,250.00,0.00,250.00,250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:31:43','2020-01-28 03:31:43'),(46,70,48,48,2.0000,350.00,0.00,350.00,350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:34:36','2020-01-28 03:34:36'),(47,71,49,49,1.0000,400.00,0.00,400.00,400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:36:23','2020-01-28 03:36:23'),(48,72,50,50,1.0000,450.00,0.00,450.00,450.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:38:56','2020-01-28 03:38:56'),(49,73,51,51,1.0000,1000.00,0.00,1000.00,1000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 03:40:57','2020-01-28 03:40:57'),(50,76,39,39,5.0000,35.00,0.00,35.00,35.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 18:55:44','2020-01-28 18:55:44'),(51,77,15,15,1.0000,500.00,0.00,500.00,500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-28 18:56:30','2020-01-28 18:56:30'),(52,80,52,52,1.0000,325.00,0.00,325.00,325.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:23:12','2020-01-29 21:23:12'),(53,81,53,53,2.0000,95.00,0.00,95.00,95.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:29:29','2020-01-29 21:29:29'),(54,82,54,54,4.0000,140.00,0.00,140.00,140.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:36:54','2020-01-29 21:36:54'),(55,83,55,55,3.0000,180.00,0.00,180.00,180.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:40:06','2020-01-29 21:40:06'),(56,84,56,56,4.0000,240.00,0.00,240.00,240.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:52:24','2020-01-29 21:52:24'),(57,85,57,57,2.0000,240.00,0.00,240.00,240.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 21:58:07','2020-01-29 21:58:07'),(58,86,58,58,3.0000,170.00,0.00,170.00,170.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:17:47','2020-02-01 22:51:06'),(59,87,59,59,3.0000,130.00,0.00,130.00,130.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:20:42','2020-01-29 22:20:42'),(60,88,60,60,2.0000,110.00,0.00,110.00,110.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:26:06','2020-01-29 22:26:06'),(61,89,61,61,2.0000,235.00,0.00,235.00,235.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:45:01','2020-01-31 17:43:10'),(62,90,62,62,1.0000,150.00,0.00,150.00,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:48:16','2020-01-29 22:48:16'),(63,91,63,63,1.0000,250.00,0.00,250.00,250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:50:21','2020-01-29 22:50:21'),(64,92,64,64,1.0000,120.00,0.00,120.00,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:55:17','2020-01-29 22:55:17'),(65,93,65,65,2.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 22:58:19','2020-01-29 22:58:19'),(66,94,66,66,3.0000,15.00,0.00,15.00,15.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:00:44','2020-01-29 23:00:44'),(67,95,67,67,1.0000,170.00,0.00,170.00,170.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:08:36','2020-01-29 23:08:36'),(68,96,68,68,1.0000,160.00,0.00,160.00,160.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:10:53','2020-01-29 23:10:53'),(69,97,69,69,1.0000,190.00,0.00,190.00,190.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:15:33','2020-01-29 23:15:33'),(70,98,70,70,1.0000,265.00,0.00,265.00,265.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:17:09','2020-01-29 23:17:09'),(71,99,71,71,2.0000,420.00,0.00,420.00,420.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:34:27','2020-01-29 23:34:27'),(72,100,72,72,1.0000,660.00,0.00,660.00,660.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:37:25','2020-01-29 23:37:25'),(73,101,73,73,1.0000,800.00,0.00,800.00,800.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-29 23:57:08','2020-01-29 23:57:08'),(74,102,74,74,1.0000,710.00,0.00,710.00,710.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:02:01','2020-01-30 00:02:01'),(75,103,75,75,1.0000,850.00,0.00,850.00,850.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:05:40','2020-01-30 00:05:40'),(76,104,76,76,1.0000,620.00,0.00,620.00,620.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:08:49','2020-01-30 00:08:49'),(77,105,77,77,1.0000,620.00,0.00,620.00,620.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:12:32','2020-01-30 00:12:32'),(78,106,78,78,1.0000,350.00,0.00,350.00,350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:14:41','2020-01-30 00:14:41'),(79,107,80,80,1.0000,770.00,0.00,770.00,770.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:18:24','2020-01-30 00:18:24'),(80,108,81,81,1.0000,370.00,0.00,370.00,370.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 00:20:36','2020-01-30 00:20:36'),(81,109,82,82,1.0000,700.00,0.00,700.00,700.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 03:23:29','2020-01-30 03:23:38'),(82,111,83,83,1.0000,450.00,0.00,450.00,450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 03:25:08','2020-01-30 03:25:15'),(84,118,85,85,30.0000,10.00,0.00,10.00,10.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 03:35:24','2020-01-30 03:39:05'),(85,122,86,86,249.0000,14.00,0.00,14.00,14.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 19:47:34','2020-01-31 17:38:39'),(86,123,87,87,95.0000,35.00,0.00,35.00,35.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-30 20:04:50','2020-01-30 20:04:50'),(87,135,88,88,100.0000,500.00,0.00,500.00,500.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-01-31 18:31:00','2020-01-31 18:35:22'),(88,141,89,89,1.0000,950.00,0.00,950.00,950.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-02-01 02:46:36','2020-02-01 02:46:36'),(89,142,89,89,1.0000,950.00,0.00,950.00,950.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-02-01 02:47:37','2020-02-01 02:48:43'),(90,150,90,90,2.0000,65.00,0.00,65.00,65.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2020-02-02 01:17:16','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',10,1,'2020-01-27 03:00:32','2020-02-01 02:23:11'),(2,'business_location',1,1,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(3,'expense',23,1,'2020-01-27 04:11:26','2020-02-01 16:57:09'),(4,'expense_payment',21,1,'2020-01-27 04:14:19','2020-02-01 16:57:35'),(5,'stock_adjustment',1,1,'2020-01-27 04:32:32','2020-01-27 04:32:32'),(6,'purchase',2,1,'2020-01-27 05:06:01','2020-02-01 02:47:37'),(7,'purchase_payment',7,1,'2020-01-27 05:06:01','2020-02-01 02:47:37'),(8,'sell_payment',33,1,'2020-01-27 05:10:10','2020-02-02 01:18:38'),(9,'opening_balance',6,1,'2020-01-27 20:08:44','2020-02-01 01:45:22'),(10,'username',1,1,'2020-01-27 20:39:15','2020-01-27 20:39:15');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (38,2),(39,2),(40,2),(41,2),(70,2);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2020-01-27 03:00:32','2020-01-27 03:00:32'),(2,'Cashier#1','web',1,0,0,'2020-01-27 03:00:32','2020-01-27 03:00:32');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `unit_price` decimal(20,2) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','2.14.1'),(2,'default_business_active_status','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(8,2) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `payment_for` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (1,2,1,0,400.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-26 23:14:19',1,NULL,NULL,NULL,NULL,'2020/0001',NULL,'2020-01-27 04:14:19','2020-01-27 04:14:19'),(2,1,1,0,20.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-26 23:14:33',1,NULL,NULL,NULL,NULL,'2020/0002',NULL,'2020-01-27 04:14:33','2020-01-27 04:14:33'),(3,3,1,0,1650.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 00:06:01',1,2,NULL,NULL,NULL,'PP2020/0001',NULL,'2020-01-27 05:06:01','2020-01-27 05:06:01'),(6,10,1,0,1000.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 00:27:03',1,1,NULL,NULL,NULL,'SP2020/0003',NULL,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(7,11,1,0,120.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 00:29:32',1,1,NULL,NULL,NULL,'SP2020/0004',NULL,'2020-01-27 05:29:32','2020-01-27 05:29:32'),(8,12,1,0,390.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-26 00:34:15',1,NULL,NULL,NULL,NULL,'2020/0003',NULL,'2020-01-27 05:34:15','2020-01-27 05:34:15'),(11,NULL,1,0,0.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:20:24',1,5,NULL,NULL,NULL,'SP2020/0006',NULL,'2020-01-27 20:20:24','2020-01-27 20:20:24'),(12,NULL,1,0,0.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:32:37',1,5,NULL,NULL,NULL,'SP2020/0007',NULL,'2020-01-27 20:32:37','2020-01-27 20:32:37'),(13,22,1,0,350.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:32:58',1,1,NULL,NULL,NULL,'SP2020/0008',NULL,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(14,NULL,1,0,0.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:34:29',1,5,NULL,NULL,NULL,'SP2020/0009',NULL,'2020-01-27 20:34:29','2020-01-27 20:34:29'),(15,24,1,0,350.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:46:42',1,1,NULL,NULL,NULL,'SP2020/0010',NULL,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(16,27,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 15:51:51',1,1,NULL,NULL,NULL,'SP2020/0011',NULL,'2020-01-27 20:51:51','2020-01-27 20:51:51'),(17,37,1,0,3200.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 16:59:32',1,1,NULL,NULL,NULL,'SP2020/0012',NULL,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(18,38,1,0,1000.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 17:01:10',1,1,NULL,NULL,NULL,'SP2020/0013',NULL,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(19,60,1,0,50.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:02:30',1,NULL,NULL,NULL,NULL,'2020/0004',NULL,'2020-01-28 03:02:30','2020-01-28 03:02:30'),(20,61,1,0,30.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:03:36',1,NULL,NULL,NULL,NULL,'2020/0005',NULL,'2020-01-28 03:03:36','2020-01-28 03:03:36'),(21,74,1,0,125.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:03:19',1,NULL,NULL,'125+1900',NULL,'2020/0006',NULL,'2020-01-28 04:03:19','2020-01-28 04:03:19'),(22,75,1,0,25.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:08:25',1,NULL,NULL,NULL,NULL,'2020/0007',NULL,'2020-01-28 04:08:25','2020-01-28 04:08:25'),(23,78,1,0,3200.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 16:36:14',1,1,NULL,NULL,NULL,'SP2020/0014',NULL,'2020-01-28 21:36:14','2020-01-28 21:36:14'),(24,79,1,0,50.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 16:15:09',1,NULL,NULL,NULL,NULL,'2020/0008',NULL,'2020-01-29 21:15:09','2020-01-29 21:15:09'),(25,110,1,0,700.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:23:38',1,1,NULL,NULL,NULL,'SP2020/0015',NULL,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(26,112,1,0,450.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:25:14',1,1,NULL,NULL,NULL,'SP2020/0016',NULL,'2020-01-30 03:25:14','2020-01-30 03:25:14'),(28,115,1,0,30.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:27:49',1,NULL,NULL,NULL,NULL,'2020/0009',NULL,'2020-01-30 03:27:49','2020-01-30 03:27:49'),(29,116,1,0,180.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:28:49',1,NULL,NULL,NULL,NULL,'2020/0010',NULL,'2020-01-30 03:28:49','2020-01-30 03:28:49'),(30,117,1,0,45.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:29:33',1,NULL,NULL,NULL,NULL,'2020/0011',NULL,'2020-01-30 03:29:33','2020-01-30 03:29:33'),(31,119,1,0,80.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:39:05',1,1,NULL,NULL,NULL,'SP2020/0018',NULL,'2020-01-30 03:39:05','2020-01-30 03:39:05'),(32,120,1,0,180.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:11:52',1,NULL,NULL,NULL,NULL,'2020/0012',NULL,'2020-01-30 04:11:52','2020-01-30 04:11:52'),(33,121,1,0,35.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:13:13',1,NULL,NULL,NULL,NULL,'2020/0013',NULL,'2020-01-30 04:13:13','2020-01-30 04:13:13'),(35,125,1,0,50.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 15:13:36',1,6,NULL,'Due 30 and 300',NULL,'SP2020/0020',NULL,'2020-01-30 20:13:36','2020-01-30 20:13:36'),(37,129,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 00:26:46',1,NULL,NULL,'Powersupply repair',NULL,'2020/0014',NULL,'2020-01-31 05:26:46','2020-01-31 05:26:46'),(38,128,1,0,300.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 00:27:12',1,NULL,NULL,'Water auto',NULL,'2020/0015',NULL,'2020-01-31 05:27:12','2020-01-31 05:27:12'),(39,130,1,0,20.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 12:38:39',1,6,NULL,NULL,NULL,'SP2020/0022',NULL,'2020-01-31 17:38:39','2020-01-31 17:38:39'),(40,132,1,0,0.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 12:43:10',1,6,NULL,NULL,NULL,'SP2020/0023',NULL,'2020-01-31 17:43:10','2020-01-31 18:08:46'),(41,NULL,1,0,300.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 12:45:07',1,6,NULL,NULL,NULL,'SP2020/0024',NULL,'2020-01-31 17:45:07','2020-01-31 17:45:07'),(42,130,1,0,30.00,'cash','cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 12:45:07',1,6,41,NULL,NULL,'SP2020/0025',NULL,'2020-01-31 17:45:07','2020-01-31 17:45:07'),(43,131,1,0,270.00,'cash','cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 12:45:07',1,6,41,NULL,NULL,'PP2020/0003',NULL,'2020-01-31 17:45:07','2020-01-31 17:45:07'),(44,NULL,1,0,6000.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:14:44',1,5,NULL,NULL,NULL,'SP2020/0026',NULL,'2020-01-31 18:14:44','2020-01-31 18:14:44'),(45,21,1,0,6000.00,'cash','cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:14:44',1,5,44,NULL,NULL,'PP2020/0004',NULL,'2020-01-31 18:14:44','2020-01-31 18:14:44'),(46,134,1,0,50.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:23:09',1,NULL,NULL,NULL,NULL,'2020/0016',NULL,'2020-01-31 18:23:09','2020-01-31 18:23:09'),(47,136,1,0,500.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:35:22',1,7,NULL,NULL,NULL,'SP2020/0027',NULL,'2020-01-31 18:35:22','2020-01-31 18:35:22'),(48,NULL,1,0,500.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:37:51',1,3,NULL,NULL,NULL,'SP2020/0028',NULL,'2020-01-31 18:37:51','2020-01-31 18:37:51'),(49,20,1,0,500.00,'cash','cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:37:51',1,3,48,NULL,NULL,'PP2020/0005',NULL,'2020-01-31 18:37:51','2020-01-31 18:37:51'),(50,NULL,1,0,650.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:47:14',1,8,NULL,'speaker 2 ta, motherboard 2ta,powersupply 1ta',NULL,'SP2020/0029',NULL,'2020-01-31 18:47:14','2020-01-31 18:48:55'),(51,137,1,0,650.00,'cash','cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 13:48:55',1,8,50,'moterboar repair 2 ta, speraker repair 2 ta, power supply repair 1 ta',NULL,'PP2020/0006',NULL,'2020-01-31 18:47:14','2020-01-31 18:48:55'),(52,138,1,0,120.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 20:38:52',1,NULL,NULL,'Lunch,Nasta',NULL,'2020/0017',NULL,'2020-02-01 01:38:52','2020-02-01 01:38:52'),(53,140,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 21:16:27',1,NULL,NULL,'Rasel Rafi Enterprise',NULL,'2020/0018',NULL,'2020-02-01 02:16:27','2020-02-01 02:16:27'),(54,142,1,0,950.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 21:47:37',1,10,NULL,NULL,NULL,'PP2020/0007',NULL,'2020-02-01 02:47:37','2020-02-01 02:47:37'),(55,143,1,0,500.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 22:55:34',1,NULL,NULL,'Basta sheka joma',NULL,'2020/0019',NULL,'2020-02-01 03:55:34','2020-02-01 03:55:34'),(56,144,1,0,1000.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 22:58:15',1,NULL,NULL,'Gabinda laptop repair',NULL,'2020/0020',NULL,'2020-02-01 03:58:15','2020-02-01 03:58:15'),(57,147,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 11:57:35',1,NULL,NULL,'Own Bank',NULL,'2020/0021',NULL,'2020-02-01 16:57:35','2020-02-01 16:57:35'),(60,149,1,0,480.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 17:51:06',1,1,NULL,NULL,NULL,'SP2020/0032',NULL,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(61,151,1,0,100.00,'cash',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 20:18:38',1,1,NULL,'Suvo seramix 2remot',NULL,'SP2020/0033',NULL,'2020-02-02 01:18:38','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `unit_price_before_discount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price` decimal(20,2) DEFAULT NULL,
  `line_discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_discount_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `unit_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text COLLATE utf8mb4_unicode_ci,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES (3,10,5,5,1.0000,0.0000,500.00,500.00,'fixed',0.00,500.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(4,10,4,4,1.0000,0.0000,500.00,500.00,'fixed',0.00,500.00,0.00,NULL,NULL,NULL,'123',NULL,NULL,NULL,NULL,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(5,11,1,1,1.0000,0.0000,120.00,120.00,'fixed',0.00,120.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 05:29:32','2020-01-27 05:31:29'),(6,13,4,4,1.0000,0.0000,500.00,500.00,'fixed',0.00,500.00,0.00,NULL,NULL,NULL,'1y',NULL,NULL,NULL,NULL,'2020-01-27 14:12:34','2020-01-27 14:12:34'),(13,22,3,3,1.0000,0.0000,350.00,350.00,'fixed',0.00,350.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(15,24,3,3,1.0000,0.0000,350.00,350.00,'fixed',0.00,350.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(16,27,1,1,1.0000,0.0000,100.00,100.00,'fixed',0.00,100.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 20:51:51','2020-01-27 20:51:51'),(17,37,8,8,1.0000,0.0000,3200.00,3200.00,'fixed',0.00,3200.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(18,38,2,2,1.0000,0.0000,1000.00,1000.00,'fixed',0.00,1000.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(19,78,37,37,1.0000,0.0000,3200.00,3200.00,'fixed',0.00,3200.00,0.00,NULL,NULL,NULL,'365',NULL,NULL,NULL,NULL,'2020-01-28 21:36:14','2020-01-28 21:36:14'),(20,110,82,82,1.0000,0.0000,700.00,700.00,'fixed',0.00,700.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(21,112,83,83,1.0000,0.0000,450.00,450.00,'fixed',0.00,450.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-30 03:25:14','2020-01-30 03:25:14'),(23,119,85,85,2.0000,0.0000,50.00,50.00,'fixed',0.00,50.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-30 03:39:05','2020-01-30 03:39:05'),(25,125,86,86,1.0000,0.0000,50.00,50.00,'fixed',0.00,50.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-30 20:13:36','2020-01-30 20:13:36'),(27,127,86,86,1.0000,0.0000,50.00,50.00,'fixed',0.00,50.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-30 20:17:20','2020-01-30 20:17:20'),(28,130,86,86,1.0000,0.0000,50.00,50.00,'fixed',0.00,50.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-31 17:38:39','2020-01-31 17:38:39'),(29,132,61,61,1.0000,0.0000,300.00,300.00,'fixed',0.00,300.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-31 17:43:10','2020-01-31 18:08:46'),(30,136,88,88,3.0000,0.0000,1000.00,1000.00,'fixed',0.00,1000.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-01-31 18:33:21','2020-01-31 18:35:22'),(32,149,58,58,1.0000,0.0000,500.00,500.00,'fixed',0.00,500.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(33,151,90,90,1.0000,0.0000,120.00,120.00,'fixed',0.00,120.00,0.00,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,'2020-02-02 01:18:38','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(20,4) NOT NULL,
  `qty_returned` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES (3,3,NULL,2,1.0000,0.0000,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(4,4,NULL,3,1.0000,0.0000,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(5,5,NULL,4,1.0000,0.0000,'2020-01-27 05:29:32','2020-01-27 05:29:32'),(6,13,NULL,1,1.0000,0.0000,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(7,15,NULL,1,1.0000,0.0000,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(8,16,NULL,4,1.0000,0.0000,'2020-01-27 20:51:51','2020-01-27 20:51:51'),(9,17,NULL,8,1.0000,0.0000,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(10,18,NULL,5,1.0000,0.0000,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(11,19,NULL,36,1.0000,0.0000,'2020-01-28 21:36:14','2020-01-28 21:36:14'),(12,20,NULL,81,1.0000,0.0000,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(13,21,NULL,82,1.0000,0.0000,'2020-01-30 03:25:15','2020-01-30 03:25:15'),(15,23,NULL,84,2.0000,0.0000,'2020-01-30 03:39:05','2020-01-30 03:39:05'),(17,25,NULL,85,1.0000,0.0000,'2020-01-30 20:13:36','2020-01-30 20:13:36'),(19,28,NULL,85,1.0000,0.0000,'2020-01-31 17:38:39','2020-01-31 17:38:39'),(20,29,NULL,61,1.0000,0.0000,'2020-01-31 17:43:10','2020-01-31 17:43:10'),(21,30,NULL,87,1.0000,0.0000,'2020-01-31 18:33:21','2020-01-31 18:33:21'),(22,30,NULL,87,2.0000,0.0000,'2020-01-31 18:35:22','2020-01-31 18:35:22'),(24,32,NULL,58,1.0000,0.0000,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(25,33,NULL,90,1.0000,0.0000,'2020-02-02 01:18:38','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('purchase','sell','expense','stock_adjustment','sell_transfer','purchase_transfer','opening_stock','sell_return','opening_balance','purchase_return') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('received','pending','ordered','draft','final') COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT '0',
  `payment_status` enum('paid','due','partial') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(20,2) NOT NULL DEFAULT '0.00',
  `discount_type` enum('fixed','percentage') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_details` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_charges` decimal(20,2) NOT NULL DEFAULT '0.00',
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `staff_note` text COLLATE utf8mb4_unicode_ci,
  `final_total` decimal(20,2) NOT NULL DEFAULT '0.00',
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT '0',
  `is_suspend` tinyint(1) NOT NULL DEFAULT '0',
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `total_amount_recovered` decimal(20,2) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `order_addresses` text COLLATE utf8mb4_unicode_ci,
  `is_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `recur_interval` double(8,2) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-26 23:10:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Muri',NULL,20.00,7,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 04:11:26','2020-01-28 03:05:08'),(2,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-26 23:13:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Laptop Keyboard By Milon',NULL,400.00,1,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 04:13:44','2020-01-27 04:14:19'),(3,1,1,NULL,NULL,NULL,'purchase',NULL,'received',0,'paid',NULL,2,NULL,NULL,'PO2020/0001',NULL,'2020-01-27 00:00:00',1650.00,NULL,0.00,'fixed','0',NULL,0.00,NULL,NULL,1650.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:06:01','2020-01-27 05:06:01'),(6,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 00:23:09',480.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,480.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:23:09','2020-01-27 05:23:09'),(7,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 00:23:47',750.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,750.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:23:47','2020-01-27 05:35:30'),(8,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 00:24:07',700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:24:07','2020-01-27 05:24:07'),(9,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 00:24:44',1500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1500.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:24:44','2020-01-28 00:50:48'),(10,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0003','',NULL,'2020-01-26 00:25:00',1000.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,'days',0,'2020-01-27 05:27:03','2020-01-27 05:27:03'),(11,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0004','',NULL,'2020-01-26 00:27:00',120.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,120.00,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 05:29:32','2020-01-27 05:31:29'),(12,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-26 00:33:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'December 2019',NULL,390.00,5,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 05:33:53','2020-01-27 05:34:15'),(13,1,1,NULL,NULL,NULL,'sell',NULL,'draft',1,NULL,NULL,1,NULL,'jaUwc','',NULL,'2020-01-27 09:12:34',500.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,500.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 14:12:34','2020-01-27 14:12:34'),(20,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'partial',NULL,3,NULL,NULL,'2020/0001',NULL,'2020-01-27 15:08:44',3500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3500.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:08:44','2020-01-31 18:37:51'),(21,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'partial',NULL,5,NULL,NULL,'2020/0002',NULL,'2020-01-27 15:13:24',6000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,12000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:13:24','2020-01-31 18:14:44'),(22,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0005','',NULL,'2020-01-27 15:32:58',350.00,NULL,0.00,'percentage','0',NULL,0.00,'234',NULL,350.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 20:32:58','2020-01-27 20:32:58'),(24,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0006','',NULL,'2020-01-27 15:46:42',350.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,350.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 20:46:42','2020-01-27 20:46:42'),(25,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:47:16',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:47:16','2020-01-27 20:47:16'),(26,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:50:29',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,7,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:50:29','2020-01-27 20:50:29'),(27,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0007','',NULL,'2020-01-27 15:51:51',100.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,100.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,'d124bf93fa4809bab0b7c2d686ec4b63',NULL,NULL,0,'2020-01-27 20:51:51','2020-01-27 20:54:54'),(28,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:53:32',4400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4400.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,8,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:53:32','2020-01-27 20:53:32'),(29,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:55:42',6400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,6400.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,9,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:55:42','2020-01-27 20:55:42'),(30,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:58:41',3600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3600.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,10,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 20:58:41','2020-01-27 20:58:41'),(31,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:00:54',1700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,11,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:00:54','2020-01-27 21:00:54'),(32,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:02:59',2600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2600.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,12,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:02:59','2020-01-27 21:02:59'),(33,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:04:39',3700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,13,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:04:39','2020-01-27 21:04:39'),(34,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:06:19',1300.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1300.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,14,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:06:19','2020-01-27 21:06:19'),(35,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:10:07',350.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,350.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,16,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:10:07','2020-01-27 21:10:07'),(36,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:12:37',350.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,350.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,17,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 21:12:37','2020-01-27 21:12:37'),(37,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0008','',NULL,'2020-01-27 16:59:32',3200.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,3200.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 21:59:32','2020-01-27 21:59:32'),(38,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0009','',NULL,'2020-01-27 17:01:10',1000.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-27 22:01:10','2020-01-27 22:01:10'),(39,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:35:00',180.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,180.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,18,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:35:00','2020-01-27 22:35:00'),(40,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:38:52',1130.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1130.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,19,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:38:52','2020-01-27 22:38:52'),(41,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:43:14',1150.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1150.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,20,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:43:14','2020-01-27 22:43:14'),(42,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:53:12',1000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,22,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:53:12','2020-01-27 22:53:12'),(43,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:53:21',800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,800.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,21,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 22:53:21','2020-01-27 22:53:21'),(44,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:00:01',230.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,230.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,24,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:00:01','2020-01-27 23:00:01'),(45,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:00:42',300.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,23,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:00:42','2020-01-27 23:00:42'),(46,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:03:56',230.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,230.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,25,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:03:56','2020-01-27 23:03:56'),(47,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:06:55',240.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,240.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,26,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:06:55','2020-01-27 23:06:55'),(48,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:09:34',225.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,225.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,27,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:09:34','2020-01-27 23:09:34'),(49,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:12:13',285.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,285.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,28,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:12:13','2020-01-27 23:12:13'),(50,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:16:15',600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,600.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,29,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:16:15','2020-01-27 23:16:15'),(51,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:19:14',620.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,620.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,30,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:19:14','2020-01-27 23:19:14'),(52,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:21:48',420.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,420.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,31,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:21:48','2020-01-27 23:21:48'),(53,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:25:41',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,32,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:25:41','2020-01-27 23:25:41'),(54,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:28:18',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,33,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:28:18','2020-01-27 23:28:18'),(55,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:33:54',780.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,780.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,34,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:33:54','2020-01-27 23:33:54'),(56,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:36:44',2000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,2000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,35,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:36:44','2020-01-27 23:36:44'),(57,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:39:24',750.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,750.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,36,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:39:24','2020-01-27 23:39:24'),(58,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:41:45',4600.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,4600.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,37,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:41:45','2020-01-29 21:17:26'),(59,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:53:45',150.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,150.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,38,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-27 23:53:45','2020-01-27 23:53:45'),(60,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'EP2020/0004',NULL,'2020-01-27 22:01:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Rang buy',NULL,50.00,6,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:02:15','2020-01-28 03:02:30'),(61,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'EP2020/0005',NULL,'2020-01-27 22:03:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,30.00,7,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:03:26','2020-01-28 03:03:36'),(62,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:09:32',700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,40,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:09:32','2020-01-28 03:09:32'),(63,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:13:48',720.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,720.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,41,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:13:48','2020-01-28 03:13:48'),(64,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:16:55',770.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,770.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,42,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:16:55','2020-01-28 03:16:55'),(65,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:18:49',440.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,440.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,43,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:18:49','2020-01-28 03:18:49'),(66,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:22:33',195.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,195.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,44,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:22:33','2020-01-28 03:22:33'),(67,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:24:40',170.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,170.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,45,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:24:40','2020-01-28 03:24:40'),(68,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:29:10',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,46,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:29:10','2020-01-28 03:29:10'),(69,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:31:43',500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,500.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,47,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:31:43','2020-01-28 03:31:43'),(70,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:34:36',700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,48,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:34:36','2020-01-28 03:34:36'),(71,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:36:23',400.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,400.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,49,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:36:23','2020-01-28 03:36:23'),(72,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:38:56',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,50,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:38:56','2020-01-28 03:38:56'),(73,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:40:57',1000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,51,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 03:40:57','2020-01-28 03:40:57'),(74,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Milon',NULL,'2020-01-27 23:00:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Milon Medecine',NULL,125.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 04:01:17','2020-01-28 04:03:19'),(75,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-27 23:06:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Medesin',NULL,25.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 04:08:07','2020-01-28 04:08:25'),(76,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 13:55:44',175.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,175.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,39,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 18:55:44','2020-01-28 18:55:44'),(77,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 13:56:30',500.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,500.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,15,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-28 18:56:30','2020-01-28 18:56:30'),(78,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0010','',NULL,'2020-01-28 16:36:14',3200.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,3200.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,'7bcef5708ee52a83b9454daf4726eb6d',NULL,NULL,0,'2020-01-28 21:36:14','2020-01-28 21:39:55'),(79,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Milon',NULL,'2020-01-28 16:13:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Milon',NULL,50.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:14:53','2020-01-29 21:15:09'),(80,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:23:12',325.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,325.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,52,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:23:12','2020-01-29 21:23:12'),(81,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:29:29',190.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,190.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,53,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:29:29','2020-01-29 21:29:29'),(82,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:36:54',560.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,560.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,54,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:36:54','2020-01-29 21:36:54'),(83,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:40:06',540.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,540.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,55,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:40:06','2020-01-29 21:40:06'),(84,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:52:24',960.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,960.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,56,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:52:24','2020-01-29 21:52:24'),(85,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 16:58:07',480.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,480.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,57,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 21:58:07','2020-01-29 21:58:07'),(86,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:17:47',510.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,510.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,58,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:17:47','2020-01-29 22:17:47'),(87,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:20:42',390.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,390.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,59,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:20:42','2020-01-29 22:20:42'),(88,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:26:06',220.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,220.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,60,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:26:06','2020-01-29 22:26:06'),(89,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:45:01',470.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,470.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,61,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:45:01','2020-01-29 22:45:01'),(90,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:48:16',150.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,150.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,62,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:48:16','2020-01-29 22:48:16'),(91,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:50:21',250.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,250.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,63,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:50:21','2020-01-29 22:50:21'),(92,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:55:17',120.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,120.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,64,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:55:17','2020-01-29 22:55:17'),(93,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 17:58:19',30.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,30.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,65,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 22:58:19','2020-01-29 22:58:19'),(94,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:00:44',45.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,45.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,66,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:00:44','2020-01-29 23:00:44'),(95,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:08:36',170.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,170.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,67,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:08:36','2020-01-29 23:08:36'),(96,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:10:53',160.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,160.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,68,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:10:53','2020-01-29 23:10:53'),(97,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:15:33',190.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,190.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,69,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:15:33','2020-01-29 23:15:33'),(98,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:17:09',265.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,265.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,70,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:17:09','2020-01-29 23:17:09'),(99,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:34:27',840.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,840.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,71,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:34:27','2020-01-29 23:34:27'),(100,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:37:25',660.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,660.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,72,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:37:25','2020-01-29 23:37:25'),(101,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 18:57:08',800.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,800.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,73,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-29 23:57:08','2020-01-29 23:57:08'),(102,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:02:01',710.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,710.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,74,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:02:01','2020-01-30 00:02:01'),(103,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:05:40',850.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,850.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,75,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:05:40','2020-01-30 00:05:40'),(104,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:08:49',620.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,620.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,76,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:08:49','2020-01-30 00:08:49'),(105,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:12:32',620.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,620.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,77,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:12:32','2020-01-30 00:12:32'),(106,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:14:41',350.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,350.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,78,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:14:41','2020-01-30 00:14:41'),(107,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:18:24',770.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,770.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,80,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:18:24','2020-01-30 00:18:24'),(108,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 19:20:36',370.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,370.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,81,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 00:20:36','2020-01-30 00:20:36'),(109,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:23:29',700.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,82,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:23:29','2020-01-30 03:23:29'),(110,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0011','',NULL,'2020-01-29 22:23:38',700.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,700.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-30 03:23:38','2020-01-30 03:23:38'),(111,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:25:08',450.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,83,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:25:08','2020-01-30 03:25:08'),(112,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0012','',NULL,'2020-01-29 22:25:14',450.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,450.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-30 03:25:14','2020-01-30 03:25:15'),(113,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:26:13',160.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,160.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,84,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:26:13','2020-01-30 03:26:13'),(115,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-29 22:27:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,30.00,7,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:27:40','2020-01-30 03:27:49'),(116,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-29 22:27:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,180.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:28:42','2020-01-30 03:28:49'),(117,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-29 22:28:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Medecine',NULL,45.00,8,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:29:25','2020-01-30 03:29:33'),(118,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 22:35:24',300.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,85,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 03:35:24','2020-01-30 03:35:24'),(119,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0014','',NULL,'2020-01-29 22:38:00',100.00,NULL,0.00,'percentage','20',NULL,0.00,NULL,NULL,80.00,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-30 03:39:05','2020-01-30 03:39:05'),(120,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-29 23:10:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Ball 2 ta',NULL,180.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 04:11:27','2020-01-30 04:11:52'),(121,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-29 23:12:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Chuigum',NULL,35.00,8,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 04:13:00','2020-01-30 04:13:13'),(122,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 14:47:34',3486.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3486.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,86,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 19:47:34','2020-01-30 19:47:34'),(123,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 15:04:50',3325.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,3325.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,87,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-30 20:04:50','2020-01-30 20:04:50'),(125,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,6,NULL,'0016','',NULL,'2020-01-30 15:11:00',50.00,NULL,0.00,'percentage','0',NULL,0.00,'Due 30 and 300',NULL,50.00,NULL,NULL,NULL,NULL,1,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,'months',0,'2020-01-30 20:13:36','2020-01-30 20:13:36'),(127,1,1,NULL,NULL,NULL,'sell',NULL,'draft',0,NULL,NULL,1,NULL,'uRQg2','',NULL,'2020-01-30 15:17:20',50.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,50.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,'months',0,'2020-01-30 20:17:20','2020-01-30 20:17:20'),(128,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-30 00:21:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Water auto',NULL,300.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 05:23:00','2020-01-31 05:27:12'),(129,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Milon',NULL,'2020-01-30 00:23:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'power supply 100',NULL,100.00,9,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 05:24:13','2020-01-31 05:26:46'),(130,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,6,NULL,'0018','',NULL,'2020-01-31 12:38:39',50.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,50.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,'months',0,'2020-01-31 17:38:39','2020-01-31 17:45:07'),(131,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'partial',NULL,6,NULL,NULL,'2020/0003',NULL,'2020-01-31 12:40:21',300.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 17:40:21','2020-01-31 17:45:07'),(132,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'due',NULL,6,NULL,'0019','',NULL,'2020-01-31 12:43:10',300.00,NULL,0.00,'percentage','0',NULL,0.00,NULL,NULL,300.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,'months',0,'2020-01-31 17:43:10','2020-01-31 18:08:46'),(133,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'due',NULL,7,NULL,NULL,'2020/0004',NULL,'2020-01-31 13:06:16',1000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,1000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 18:06:16','2020-01-31 18:07:12'),(134,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'partial',NULL,NULL,NULL,NULL,'Milon',NULL,'2020-01-31 13:21:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Power Supply 100-50',NULL,100.00,9,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 18:22:14','2020-01-31 18:23:09'),(135,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 13:31:00',50000.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,50000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,88,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 18:31:00','2020-01-31 18:31:00'),(136,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'partial',NULL,7,NULL,'0020','',NULL,'2020-01-31 13:33:21',3000.00,NULL,0.00,'percentage','0',NULL,0.00,'1500 pay today','1500 pay today',3000.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-01-31 18:33:21','2020-01-31 18:35:22'),(137,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'partial',NULL,8,NULL,NULL,'2020/0005',NULL,'2020-01-31 13:42:25',5200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,5900.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-31 18:42:25','2020-02-01 01:37:18'),(138,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-31 20:37:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Lunch,Nasta',NULL,120.00,7,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 01:38:27','2020-02-01 01:38:52'),(139,1,1,NULL,NULL,NULL,'opening_balance',NULL,'final',0,'due',NULL,9,NULL,NULL,'2020/0006',NULL,'2020-01-31 20:45:22',200.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,200.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 01:45:22','2020-02-01 01:45:22'),(140,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Rasel Rafi Enterprise',NULL,'2020-01-31 21:15:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Rasel Rafi Enterprise',NULL,100.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 02:16:09','2020-02-01 02:16:27'),(141,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 21:46:36',950.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,950.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,89,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 02:46:36','2020-02-01 02:46:36'),(142,1,1,NULL,NULL,NULL,'purchase',NULL,'received',0,'paid',NULL,10,NULL,NULL,'622',NULL,'2020-01-31 21:19:00',950.00,NULL,0.00,NULL,'0',NULL,0.00,NULL,NULL,950.00,NULL,NULL,NULL,'1580485657_Laptop Battery.jpg',0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 02:47:37','2020-02-01 02:48:43'),(143,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-01-31 22:54:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Basta sheka joma',NULL,500.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 03:55:10','2020-02-01 03:55:34'),(144,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Hasan',NULL,'2020-01-31 22:57:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Gabinda laptop repair',NULL,1000.00,9,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 03:58:02','2020-02-01 03:58:15'),(145,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'due',NULL,NULL,NULL,NULL,'Nipon CF',NULL,'2020-01-31 22:59:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Gangi 2 sate',NULL,300.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 04:00:29','2020-02-01 04:00:29'),(146,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'due',NULL,NULL,NULL,NULL,'Rubel Rarmase',NULL,'2020-02-01 11:55:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'medicine',NULL,70.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 16:56:33','2020-02-01 16:56:33'),(147,1,1,NULL,NULL,NULL,'expense',NULL,'final',0,'paid',NULL,NULL,NULL,NULL,'Sudipta',NULL,'2020-02-01 11:56:00',0.00,NULL,0.00,NULL,NULL,NULL,0.00,'Bank',NULL,100.00,8,1,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-01 16:57:09','2020-02-01 16:57:35'),(149,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'paid',NULL,1,NULL,'0022','',NULL,'2020-02-01 17:51:06',500.00,NULL,0.00,'percentage','4',NULL,0.00,NULL,NULL,480.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-02-01 22:51:06','2020-02-01 22:51:06'),(150,1,1,NULL,NULL,NULL,'opening_stock',NULL,'received',0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,'2020-01-01 20:17:16',130.00,NULL,0.00,NULL,NULL,NULL,0.00,NULL,NULL,130.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,90,1,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-02 01:17:16','2020-02-02 01:17:16'),(151,1,1,NULL,NULL,NULL,'sell',NULL,'final',0,'partial',NULL,1,NULL,'0023','',NULL,'2020-02-01 20:18:38',120.00,NULL,0.00,'percentage','0',NULL,0.00,'Suvo seramix 2remot','Suvo seramix 2remot',120.00,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,0,NULL,'days',0,NULL,NULL,NULL,NULL,NULL,0,'2020-02-02 01:18:38','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES (1,1,'Pieces','Pc(s)',0,NULL,NULL,1,NULL,'2020-01-27 03:00:32','2020-01-27 03:00:32');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `surname` char(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `contact_no` char(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `status` enum('active','inactive','terminated') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT '0',
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `selected_contacts` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Mr','Sudipta','Ray','admin','sudiptaray24@gmail.com','$2y$10$B8MToeBnVBWlRUXnfcAtyeMrm7p3WStWoSFmE3o/RdgNr02VbOv7u','en',NULL,NULL,'f1cfYntnL8BkGmqtnG8kgg0mRi28cX4JrdKI5waziLBcxR6eYcZhceZxBV09',1,'active',0,0.00,0,NULL,'2020-01-27 03:00:32','2020-01-27 14:07:04'),(2,'Mr','Sudipta','Ray','Sudipta','raycomputerbd@gmail.com','$2y$10$qV4MpSNrFyD9VPyEIp6pMOz//STeE2IV8KkGMVFYrWa5b4YBxQoOy','en',NULL,NULL,NULL,1,'active',0,0.00,0,NULL,'2020-01-27 20:39:15','2020-01-27 20:39:15');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(20,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(20,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES (1,3,3,3,1,8.0000,'2020-01-27 05:06:01','2020-01-27 20:46:42'),(2,5,5,5,1,1.0000,'2020-01-27 05:23:09','2020-01-27 05:27:03'),(3,4,4,4,1,4.0000,'2020-01-27 05:23:47','2020-01-27 05:35:30'),(4,1,1,1,1,18.0000,'2020-01-27 05:24:07','2020-01-27 20:51:51'),(5,2,2,2,1,1.0000,'2020-01-27 05:24:44','2020-01-28 00:50:48'),(6,6,6,6,1,5.0000,'2020-01-27 20:47:16','2020-01-27 20:47:16'),(7,7,7,7,1,10.0000,'2020-01-27 20:50:29','2020-01-27 20:50:29'),(8,8,8,8,1,1.0000,'2020-01-27 20:53:32','2020-01-27 21:59:32'),(9,9,9,9,1,2.0000,'2020-01-27 20:55:42','2020-01-27 20:55:42'),(10,10,10,10,1,4.0000,'2020-01-27 20:58:41','2020-01-27 20:58:41'),(11,11,11,11,1,1.0000,'2020-01-27 21:00:54','2020-01-27 21:00:54'),(12,12,12,12,1,2.0000,'2020-01-27 21:02:59','2020-01-27 21:02:59'),(13,13,13,13,1,4.0000,'2020-01-27 21:04:39','2020-01-27 21:04:39'),(14,14,14,14,1,2.0000,'2020-01-27 21:06:19','2020-01-27 21:06:19'),(15,16,16,16,1,5.0000,'2020-01-27 21:10:07','2020-01-27 21:10:07'),(16,17,17,17,1,5.0000,'2020-01-27 21:12:37','2020-01-27 21:12:37'),(17,18,18,18,1,9.0000,'2020-01-27 22:35:00','2020-01-27 22:35:00'),(18,19,19,19,1,1.0000,'2020-01-27 22:38:52','2020-01-27 22:38:52'),(19,20,20,20,1,1.0000,'2020-01-27 22:43:14','2020-01-27 22:43:14'),(20,22,22,22,1,1.0000,'2020-01-27 22:53:12','2020-01-27 22:53:12'),(21,21,21,21,1,1.0000,'2020-01-27 22:53:21','2020-01-27 22:53:21'),(22,24,24,24,1,2.0000,'2020-01-27 23:00:01','2020-01-27 23:00:01'),(23,23,23,23,1,2.0000,'2020-01-27 23:00:42','2020-01-27 23:00:42'),(24,25,25,25,1,1.0000,'2020-01-27 23:03:56','2020-01-27 23:03:56'),(25,26,26,26,1,3.0000,'2020-01-27 23:06:55','2020-01-27 23:06:55'),(26,27,27,27,1,15.0000,'2020-01-27 23:09:34','2020-01-27 23:09:34'),(27,28,28,28,1,3.0000,'2020-01-27 23:12:13','2020-01-27 23:12:13'),(28,29,29,29,1,2.0000,'2020-01-27 23:16:15','2020-01-27 23:16:15'),(29,30,30,30,1,4.0000,'2020-01-27 23:19:14','2020-01-27 23:19:14'),(30,31,31,31,1,2.0000,'2020-01-27 23:21:48','2020-01-27 23:21:48'),(31,32,32,32,1,1.0000,'2020-01-27 23:25:41','2020-01-27 23:25:41'),(32,33,33,33,1,1.0000,'2020-01-27 23:28:18','2020-01-27 23:28:18'),(33,34,34,34,1,3.0000,'2020-01-27 23:33:54','2020-01-27 23:33:54'),(34,35,35,35,1,8.0000,'2020-01-27 23:36:44','2020-01-27 23:36:44'),(35,36,36,36,1,3.0000,'2020-01-27 23:39:24','2020-01-27 23:39:24'),(36,37,37,37,1,1.0000,'2020-01-27 23:41:45','2020-01-29 21:17:26'),(37,38,38,38,1,1.0000,'2020-01-27 23:53:45','2020-01-27 23:53:45'),(38,40,40,40,1,5.0000,'2020-01-28 03:09:32','2020-01-28 03:09:32'),(39,41,41,41,1,4.0000,'2020-01-28 03:13:48','2020-01-28 03:13:48'),(40,42,42,42,1,7.0000,'2020-01-28 03:16:55','2020-01-28 03:16:55'),(41,43,43,43,1,8.0000,'2020-01-28 03:18:49','2020-01-28 03:18:49'),(42,44,44,44,1,1.0000,'2020-01-28 03:22:33','2020-01-28 03:22:33'),(43,45,45,45,1,1.0000,'2020-01-28 03:24:40','2020-01-28 03:24:40'),(44,46,46,46,1,1.0000,'2020-01-28 03:29:10','2020-01-28 03:29:10'),(45,47,47,47,1,2.0000,'2020-01-28 03:31:43','2020-01-28 03:31:43'),(46,48,48,48,1,2.0000,'2020-01-28 03:34:36','2020-01-28 03:34:36'),(47,49,49,49,1,1.0000,'2020-01-28 03:36:23','2020-01-28 03:36:23'),(48,50,50,50,1,1.0000,'2020-01-28 03:38:56','2020-01-28 03:38:56'),(49,51,51,51,1,1.0000,'2020-01-28 03:40:57','2020-01-28 03:40:57'),(50,39,39,39,1,5.0000,'2020-01-28 18:55:44','2020-01-28 18:55:44'),(51,15,15,15,1,1.0000,'2020-01-28 18:56:30','2020-01-28 18:56:30'),(52,52,52,52,1,1.0000,'2020-01-29 21:23:12','2020-01-29 21:23:12'),(53,53,53,53,1,2.0000,'2020-01-29 21:29:29','2020-01-29 21:29:29'),(54,54,54,54,1,4.0000,'2020-01-29 21:36:54','2020-01-29 21:36:54'),(55,55,55,55,1,3.0000,'2020-01-29 21:40:06','2020-01-29 21:40:06'),(56,56,56,56,1,4.0000,'2020-01-29 21:52:24','2020-01-29 21:52:24'),(57,57,57,57,1,2.0000,'2020-01-29 21:58:07','2020-01-29 21:58:07'),(58,58,58,58,1,2.0000,'2020-01-29 22:17:47','2020-02-01 22:51:06'),(59,59,59,59,1,3.0000,'2020-01-29 22:20:42','2020-01-29 22:20:42'),(60,60,60,60,1,2.0000,'2020-01-29 22:26:06','2020-01-29 22:26:06'),(61,61,61,61,1,1.0000,'2020-01-29 22:45:01','2020-01-31 17:43:10'),(62,62,62,62,1,1.0000,'2020-01-29 22:48:16','2020-01-29 22:48:16'),(63,63,63,63,1,1.0000,'2020-01-29 22:50:21','2020-01-29 22:50:21'),(64,64,64,64,1,1.0000,'2020-01-29 22:55:17','2020-01-29 22:55:17'),(65,65,65,65,1,2.0000,'2020-01-29 22:58:19','2020-01-29 22:58:19'),(66,66,66,66,1,3.0000,'2020-01-29 23:00:44','2020-01-29 23:00:44'),(67,67,67,67,1,1.0000,'2020-01-29 23:08:36','2020-01-29 23:08:36'),(68,68,68,68,1,1.0000,'2020-01-29 23:10:53','2020-01-29 23:10:53'),(69,69,69,69,1,1.0000,'2020-01-29 23:15:33','2020-01-29 23:15:33'),(70,70,70,70,1,1.0000,'2020-01-29 23:17:09','2020-01-29 23:17:09'),(71,71,71,71,1,2.0000,'2020-01-29 23:34:27','2020-01-29 23:34:27'),(72,72,72,72,1,1.0000,'2020-01-29 23:37:25','2020-01-29 23:37:25'),(73,73,73,73,1,1.0000,'2020-01-29 23:57:08','2020-01-29 23:57:08'),(74,74,74,74,1,1.0000,'2020-01-30 00:02:01','2020-01-30 00:02:01'),(75,75,75,75,1,1.0000,'2020-01-30 00:05:40','2020-01-30 00:05:40'),(76,76,76,76,1,1.0000,'2020-01-30 00:08:49','2020-01-30 00:08:49'),(77,77,77,77,1,1.0000,'2020-01-30 00:12:32','2020-01-30 00:12:32'),(78,78,78,78,1,1.0000,'2020-01-30 00:14:41','2020-01-30 00:14:41'),(79,80,80,80,1,1.0000,'2020-01-30 00:18:24','2020-01-30 00:18:24'),(80,81,81,81,1,1.0000,'2020-01-30 00:20:36','2020-01-30 00:20:36'),(81,82,82,82,1,0.0000,'2020-01-30 03:23:29','2020-01-30 03:23:38'),(82,83,83,83,1,0.0000,'2020-01-30 03:25:08','2020-01-30 03:25:15'),(84,85,85,85,1,28.0000,'2020-01-30 03:35:24','2020-01-30 03:39:05'),(85,86,86,86,1,247.0000,'2020-01-30 19:47:34','2020-01-31 17:38:39'),(86,87,87,87,1,95.0000,'2020-01-30 20:04:50','2020-01-30 20:04:50'),(87,88,88,88,1,97.0000,'2020-01-31 18:31:00','2020-01-31 18:35:22'),(88,89,89,89,1,2.0000,'2020-02-01 02:46:36','2020-02-01 02:47:37'),(89,90,90,90,1,1.0000,'2020-02-02 01:17:16','2020-02-02 01:18:38');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(20,2) DEFAULT NULL,
  `dpp_inc_tax` decimal(20,2) NOT NULL DEFAULT '0.00',
  `profit_percent` decimal(20,2) NOT NULL DEFAULT '0.00',
  `default_sell_price` decimal(20,2) DEFAULT NULL,
  `sell_price_inc_tax` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES (1,'DUMMY',1,'P100',1,NULL,40.00,40.00,150.00,100.00,100.00,'2020-01-27 03:57:52','2020-01-27 20:42:34',NULL),(2,'DUMMY',2,'P101',2,NULL,750.00,750.00,33.33,1000.00,1000.00,'2020-01-27 04:06:06','2020-01-27 04:07:59',NULL),(3,'DUMMY',3,'P202',3,NULL,165.00,165.00,112.12,350.00,350.00,'2020-01-27 04:25:28','2020-01-27 04:35:13',NULL),(4,'DUMMY',4,'P303',4,NULL,150.00,150.00,233.33,500.00,500.00,'2020-01-27 04:28:05','2020-01-27 04:28:05',NULL),(5,'DUMMY',5,'P203',5,NULL,240.00,240.00,108.33,500.00,500.00,'2020-01-27 04:30:43','2020-01-27 05:22:25',NULL),(6,'DUMMY',6,'0006',6,NULL,90.00,90.00,122.22,200.00,200.00,'2020-01-27 20:47:00','2020-01-27 20:47:00',NULL),(7,'DUMMY',7,'0007',7,NULL,45.00,45.00,122.22,100.00,100.00,'2020-01-27 20:50:02','2020-01-27 20:50:02',NULL),(8,'DUMMY',8,'0008',8,NULL,2200.00,2200.00,45.45,3200.00,3200.00,'2020-01-27 20:53:20','2020-01-27 20:53:20',NULL),(9,'DUMMY',9,'0009',9,NULL,3200.00,3200.00,25.00,4000.00,4000.00,'2020-01-27 20:55:20','2020-01-27 20:55:20',NULL),(10,'DUMMY',10,'0010',10,NULL,900.00,900.00,66.67,1500.00,1500.00,'2020-01-27 20:58:26','2020-01-27 20:58:26',NULL),(11,'DUMMY',11,'0011',11,NULL,1700.00,1700.00,47.06,2500.00,2500.00,'2020-01-27 21:00:42','2020-01-27 21:00:42',NULL),(12,'DUMMY',12,'0012',12,NULL,1300.00,1300.00,69.23,2200.00,2200.00,'2020-01-27 21:02:43','2020-01-27 21:02:43',NULL),(13,'DUMMY',13,'0013',13,NULL,925.00,925.00,62.16,1500.00,1500.00,'2020-01-27 21:04:20','2020-01-27 21:04:20',NULL),(14,'DUMMY',14,'0014',14,NULL,650.00,650.00,53.85,1000.00,1000.00,'2020-01-27 21:06:03','2020-01-27 21:06:03',NULL),(15,'DUMMY',15,'0015',15,NULL,500.00,500.00,60.00,800.00,800.00,'2020-01-27 21:07:39','2020-01-27 21:07:39',NULL),(16,'DUMMY',16,'0016',16,NULL,70.00,70.00,42.86,100.00,100.00,'2020-01-27 21:09:54','2020-01-27 21:09:54',NULL),(17,'DUMMY',17,'0017',17,NULL,70.00,70.00,42.86,100.00,100.00,'2020-01-27 21:12:20','2020-01-27 21:12:20',NULL),(18,'DUMMY',18,'0018',18,NULL,20.00,20.00,250.00,70.00,70.00,'2020-01-27 22:34:40','2020-01-27 22:34:40',NULL),(19,'DUMMY',19,'0019',19,NULL,1130.00,1130.00,32.74,1500.00,1500.00,'2020-01-27 22:38:29','2020-01-27 22:44:24',NULL),(20,'DUMMY',20,'0020',20,NULL,1150.00,1150.00,26.09,1450.00,1450.00,'2020-01-27 22:42:57','2020-01-27 22:42:57',NULL),(21,'DUMMY',21,'0021',21,NULL,800.00,800.00,25.00,1000.00,1000.00,'2020-01-27 22:48:36','2020-01-27 22:48:36',NULL),(22,'DUMMY',22,'0022',22,NULL,1000.00,1000.00,30.00,1300.00,1300.00,'2020-01-27 22:52:54','2020-01-27 22:52:54',NULL),(23,'DUMMY',23,'0023',23,NULL,150.00,150.00,100.00,300.00,300.00,'2020-01-27 22:57:35','2020-01-27 22:57:35',NULL),(24,'DUMMY',24,'0024',24,NULL,115.00,115.00,160.87,300.00,300.00,'2020-01-27 22:59:35','2020-01-27 22:59:35',NULL),(25,'DUMMY',25,'0025',25,NULL,230.00,230.00,117.39,500.00,500.00,'2020-01-27 23:03:19','2020-01-27 23:03:19',NULL),(26,'DUMMY',26,'0026',26,NULL,80.00,80.00,25.00,100.00,100.00,'2020-01-27 23:06:35','2020-01-27 23:07:14',NULL),(27,'DUMMY',27,'0027',27,NULL,15.00,15.00,233.33,50.00,50.00,'2020-01-27 23:09:00','2020-01-27 23:09:00',NULL),(28,'DUMMY',28,'0028',28,NULL,95.00,95.00,163.16,250.00,250.00,'2020-01-27 23:11:56','2020-01-27 23:11:56',NULL),(29,'DUMMY',29,'0029',29,NULL,300.00,300.00,66.67,500.00,500.00,'2020-01-27 23:15:39','2020-01-27 23:15:39',NULL),(30,'DUMMY',30,'0030',30,NULL,155.00,155.00,93.55,300.00,300.00,'2020-01-27 23:18:55','2020-01-27 23:18:55',NULL),(31,'DUMMY',31,'0031',31,NULL,210.00,210.00,114.29,450.00,450.00,'2020-01-27 23:21:28','2020-01-27 23:21:28',NULL),(32,'DUMMY',32,'0032',32,NULL,450.00,450.00,33.33,600.00,600.00,'2020-01-27 23:25:11','2020-01-27 23:25:11',NULL),(33,'DUMMY',33,'0033',33,NULL,450.00,450.00,33.33,600.00,600.00,'2020-01-27 23:27:48','2020-01-27 23:27:48',NULL),(34,'DUMMY',34,'0034',34,NULL,260.00,260.00,73.08,450.00,450.00,'2020-01-27 23:33:32','2020-01-27 23:33:32',NULL),(35,'DUMMY',35,'0035',35,NULL,250.00,250.00,60.00,400.00,400.00,'2020-01-27 23:36:12','2020-01-27 23:36:12',NULL),(36,'DUMMY',36,'0036',36,NULL,250.00,250.00,80.00,450.00,450.00,'2020-01-27 23:38:48','2020-01-27 23:38:48',NULL),(37,'DUMMY',37,'0037',37,NULL,2300.00,2300.00,39.13,3200.00,3200.00,'2020-01-27 23:41:30','2020-01-29 21:17:53',NULL),(38,'DUMMY',38,'0038',38,NULL,150.00,150.00,100.00,300.00,300.00,'2020-01-27 23:53:29','2020-01-27 23:53:29',NULL),(39,'DUMMY',39,'0039',39,NULL,35.00,35.00,100.00,70.00,70.00,'2020-01-27 23:56:52','2020-01-27 23:56:52',NULL),(40,'DUMMY',40,'0040',40,NULL,140.00,140.00,78.57,250.00,250.00,'2020-01-28 03:09:04','2020-01-28 03:09:04',NULL),(41,'DUMMY',41,'0041',41,NULL,180.00,180.00,55.56,280.00,280.00,'2020-01-28 03:12:37','2020-01-28 03:12:37',NULL),(42,'DUMMY',42,'0042',42,NULL,110.00,110.00,127.27,250.00,250.00,'2020-01-28 03:16:24','2020-01-28 03:16:24',NULL),(43,'DUMMY',43,'0043',43,NULL,55.00,55.00,81.82,100.00,100.00,'2020-01-28 03:18:25','2020-01-28 03:18:25',NULL),(44,'DUMMY',44,'0044',44,NULL,195.00,195.00,48.72,290.00,290.00,'2020-01-28 03:21:52','2020-01-28 03:21:52',NULL),(45,'DUMMY',45,'0045',45,NULL,170.00,170.00,58.82,270.00,270.00,'2020-01-28 03:24:22','2020-01-28 03:25:14',NULL),(46,'DUMMY',46,'0046',46,NULL,450.00,450.00,22.22,550.00,550.00,'2020-01-28 03:28:44','2020-01-28 03:28:44',NULL),(47,'DUMMY',47,'0047',47,NULL,250.00,250.00,80.00,450.00,450.00,'2020-01-28 03:31:21','2020-01-28 03:31:21',NULL),(48,'DUMMY',48,'0048',48,NULL,350.00,350.00,28.57,450.00,450.00,'2020-01-28 03:34:15','2020-01-28 03:34:15',NULL),(49,'DUMMY',49,'0049',49,NULL,400.00,400.00,25.00,500.00,500.00,'2020-01-28 03:35:51','2020-01-28 03:35:51',NULL),(50,'DUMMY',50,'0050',50,NULL,450.00,450.00,22.22,550.00,550.00,'2020-01-28 03:38:25','2020-01-28 03:38:25',NULL),(51,'DUMMY',51,'0051',51,NULL,1000.00,1000.00,50.00,1500.00,1500.00,'2020-01-28 03:40:33','2020-01-28 03:40:33',NULL),(52,'DUMMY',52,'0052',52,NULL,325.00,325.00,69.23,550.00,550.00,'2020-01-29 21:22:49','2020-01-29 21:22:49',NULL),(53,'DUMMY',53,'0053',53,NULL,95.00,95.00,110.53,200.00,200.00,'2020-01-29 21:29:17','2020-01-29 21:29:17',NULL),(54,'DUMMY',54,'0054',54,NULL,140.00,140.00,78.57,250.00,250.00,'2020-01-29 21:36:20','2020-01-29 21:36:20',NULL),(55,'DUMMY',55,'0055',55,NULL,180.00,180.00,94.44,350.00,350.00,'2020-01-29 21:39:35','2020-01-29 21:39:35',NULL),(56,'DUMMY',56,'0056',56,NULL,240.00,240.00,45.83,350.00,350.00,'2020-01-29 21:51:41','2020-01-29 21:51:41',NULL),(57,'DUMMY',57,'0057',57,NULL,240.00,240.00,45.83,350.00,350.00,'2020-01-29 21:57:32','2020-01-29 21:57:32',NULL),(58,'DUMMY',58,'0058',58,NULL,170.00,170.00,194.12,500.00,500.00,'2020-01-29 22:17:18','2020-02-01 22:36:59',NULL),(59,'DUMMY',59,'0059',59,NULL,130.00,130.00,92.31,250.00,250.00,'2020-01-29 22:20:11','2020-01-29 22:20:11',NULL),(60,'DUMMY',60,'0060',60,NULL,110.00,110.00,127.27,250.00,250.00,'2020-01-29 22:25:15','2020-01-29 22:25:15',NULL),(61,'DUMMY',61,'0061',61,NULL,235.00,235.00,27.66,300.00,300.00,'2020-01-29 22:44:33','2020-01-29 22:44:33',NULL),(62,'DUMMY',62,'0062',62,NULL,150.00,150.00,66.67,250.00,250.00,'2020-01-29 22:48:03','2020-01-29 22:48:03',NULL),(63,'DUMMY',63,'0063',63,NULL,250.00,250.00,60.00,400.00,400.00,'2020-01-29 22:50:01','2020-01-29 22:50:01',NULL),(64,'DUMMY',64,'0064',64,NULL,120.00,120.00,108.33,250.00,250.00,'2020-01-29 22:54:34','2020-01-29 22:54:34',NULL),(65,'DUMMY',65,'0065',65,NULL,15.00,15.00,233.33,50.00,50.00,'2020-01-29 22:57:57','2020-01-29 22:57:57',NULL),(66,'DUMMY',66,'0066',66,NULL,15.00,15.00,233.33,50.00,50.00,'2020-01-29 23:00:19','2020-01-29 23:00:19',NULL),(67,'DUMMY',67,'0067',67,NULL,170.00,170.00,58.82,270.00,270.00,'2020-01-29 23:08:08','2020-01-29 23:08:08',NULL),(68,'DUMMY',68,'0068',68,NULL,160.00,160.00,62.50,260.00,260.00,'2020-01-29 23:10:26','2020-01-29 23:10:26',NULL),(69,'DUMMY',69,'0069',69,NULL,190.00,190.00,52.63,290.00,290.00,'2020-01-29 23:15:04','2020-01-29 23:15:04',NULL),(70,'DUMMY',70,'0070',70,NULL,265.00,265.00,37.74,365.00,365.00,'2020-01-29 23:16:34','2020-01-29 23:16:34',NULL),(71,'DUMMY',71,'0071',71,NULL,420.00,420.00,54.76,650.00,650.00,'2020-01-29 23:34:09','2020-01-29 23:34:09',NULL),(72,'DUMMY',72,'0072',72,NULL,660.00,660.00,30.30,860.00,860.00,'2020-01-29 23:37:08','2020-01-29 23:37:08',NULL),(73,'DUMMY',73,'0073',73,NULL,800.00,800.00,25.00,1000.00,1000.00,'2020-01-29 23:52:25','2020-01-29 23:56:55',NULL),(74,'DUMMY',74,'0074',74,NULL,710.00,710.00,28.17,910.00,910.00,'2020-01-30 00:00:57','2020-01-30 00:00:57',NULL),(75,'DUMMY',75,'0075',75,NULL,850.00,850.00,23.53,1050.00,1050.00,'2020-01-30 00:05:18','2020-01-30 00:05:18',NULL),(76,'DUMMY',76,'0076',76,NULL,620.00,620.00,32.26,820.00,820.00,'2020-01-30 00:08:19','2020-01-30 00:08:19',NULL),(77,'DUMMY',77,'0077',77,NULL,620.00,620.00,32.26,820.00,820.00,'2020-01-30 00:11:34','2020-01-30 00:11:34',NULL),(78,'DUMMY',78,'0078',78,NULL,350.00,350.00,57.14,550.00,550.00,'2020-01-30 00:14:29','2020-01-30 00:14:29',NULL),(79,'DUMMY',79,'0079',79,NULL,600.00,600.00,33.33,800.00,800.00,'2020-01-30 00:16:24','2020-01-30 00:16:24',NULL),(80,'DUMMY',80,'0080',80,NULL,770.00,770.00,55.84,1200.00,1200.00,'2020-01-30 00:17:53','2020-01-30 00:17:53',NULL),(81,'DUMMY',81,'0081',81,NULL,370.00,370.00,54.05,570.00,570.00,'2020-01-30 00:20:15','2020-01-30 00:20:15',NULL),(82,'DUMMY',82,'0082',82,NULL,700.00,700.00,0.00,700.00,700.00,'2020-01-30 03:23:29','2020-01-30 03:23:29',NULL),(83,'DUMMY',83,'0083',83,NULL,450.00,450.00,0.00,450.00,450.00,'2020-01-30 03:25:08','2020-01-30 03:25:08',NULL),(85,'DUMMY',85,'0085',85,NULL,10.00,10.00,400.00,50.00,50.00,'2020-01-30 03:34:58','2020-01-30 03:34:58',NULL),(86,'DUMMY',86,'0086',86,NULL,14.00,14.00,257.14,50.00,50.00,'2020-01-30 19:44:34','2020-01-30 19:44:34',NULL),(87,'DUMMY',87,'0087',87,NULL,35.00,35.00,185.71,100.00,100.00,'2020-01-30 20:03:32','2020-01-30 20:04:23',NULL),(88,'DUMMY',88,'0088',88,NULL,500.00,500.00,100.00,1000.00,1000.00,'2020-01-31 18:27:50','2020-01-31 18:27:50',NULL),(89,'DUMMY',89,'0089',89,NULL,950.00,950.00,57.89,1500.00,1500.00,'2020-02-01 02:45:52','2020-02-01 02:45:52',NULL),(90,'DUMMY',90,'0090',90,NULL,65.00,65.00,84.62,120.00,120.00,'2020-02-02 01:16:32','2020-02-02 01:16:32',NULL);
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

